/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.compiler;

import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.DefaultSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class AndroidGradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project myProject;
    private List<String> myClasspath;

    public AndroidGradleBuildProcessParametersProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public List<String> getClassPath() {
        if (this.myClasspath == null) {
            this.myClasspath = AndroidGradleBuildProcessParametersProvider.getGradleClassPath();
        }
        List<String> list = this.myClasspath;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getClassPath"));
        }
        return list;
    }

    @NotNull
    private static List<String> getGradleClassPath() {
        File[] children;
        String gradleLibDirPath = null;
        String gradleToolingApiJarPath = PathUtil.getJarPathForClass(ProjectConnection.class);
        if (!Strings.isNullOrEmpty((String)gradleToolingApiJarPath)) {
            gradleLibDirPath = PathUtil.getParentPath((String)gradleToolingApiJarPath);
        }
        if (gradleLibDirPath == null || gradleLibDirPath.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getGradleClassPath"));
            }
            return list;
        }
        ArrayList classpath = Lists.newArrayList();
        File gradleLibDir = new File(gradleLibDirPath);
        if (!gradleLibDir.isDirectory()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getGradleClassPath"));
            }
            return list;
        }
        for (File child : children = FileUtil.notNullize((File[])gradleLibDir.listFiles())) {
            if (!child.isFile() || !child.getName().endsWith(".jar")) continue;
            classpath.add(child.getAbsolutePath());
        }
        ArrayList arrayList = classpath;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getGradleClassPath"));
        }
        return arrayList;
    }

    @NotNull
    public List<String> getVMArguments() {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getVMArguments"));
            }
            return list;
        }
        ArrayList jvmArgs = Lists.newArrayList();
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        AndroidGradleBuildProcessParametersProvider.populateJvmArgs(buildConfiguration, jvmArgs, this.myProject);
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (executionSettings != null) {
            this.populateJvmArgs(executionSettings, (List<String>)jvmArgs);
        }
        this.populateJvmArgs(BuildSettings.getInstance(this.myProject), (List<String>)jvmArgs);
        AndroidGradleBuildProcessParametersProvider.addHttpProxySettings(jvmArgs);
        ArrayList arrayList = jvmArgs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getVMArguments"));
        }
        return arrayList;
    }

    @VisibleForTesting
    static void populateJvmArgs(@NotNull AndroidGradleBuildConfiguration buildConfiguration, @NotNull List<String> jvmArgs, @NotNull Project project) {
        if (buildConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.offline.mode", (boolean)GradleSettings.getInstance((Project)project).isOfflineWork()));
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.configuration.on.demand", (boolean)buildConfiguration.USE_CONFIGURATION_ON_DEMAND));
        String[] commandLineOptions = buildConfiguration.getCommandLineOptions();
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.daemon.command.line.option.count", (int)commandLineOptions.length));
        int optionCount = 0;
        for (String option : commandLineOptions) {
            String name = "com.android.studio.gradle.daemon.command.line.option." + optionCount;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)option));
            ++optionCount;
        }
    }

    @VisibleForTesting
    void populateJvmArgs(@NotNull GradleExecutionSettings executionSettings, @NotNull List<String> jvmArgs) {
        File javaHome;
        String serviceDirectory;
        if (executionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        String gradleHome = executionSettings.getGradleHome();
        if (gradleHome != null && !gradleHome.isEmpty()) {
            gradleHome = FileUtil.toSystemDependentName((String)gradleHome);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.home.path", (String)gradleHome));
        }
        if ((serviceDirectory = executionSettings.getServiceDirectory()) != null && !serviceDirectory.isEmpty()) {
            serviceDirectory = FileUtil.toSystemDependentName((String)serviceDirectory);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.service.dir.path", (String)serviceDirectory));
        }
        if ((javaHome = DefaultSdks.getDefaultJavaHome()) != null) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.java.home.path", (String)javaHome.getPath()));
        }
        String basePath = FileUtil.toSystemDependentName((String)this.myProject.getBasePath());
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.project.path", (String)basePath));
        boolean verboseProcessing = executionSettings.isVerboseProcessing();
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.use.verbose.logging", (boolean)verboseProcessing));
        String jvmOptions = executionSettings.getDaemonVmOptions();
        int jvmOptionCount = 0;
        if (jvmOptions != null && !jvmOptions.isEmpty()) {
            CommandLineTokenizer tokenizer = new CommandLineTokenizer(jvmOptions);
            while (tokenizer.hasMoreTokens()) {
                String name = "com.android.studio.gradle.daemon.jvm.option." + jvmOptionCount;
                jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)tokenizer.nextToken()));
                ++jvmOptionCount;
            }
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.daemon.jvm.option.count", (int)jvmOptionCount));
    }

    private static void addHttpProxySettings(@NotNull List<String> jvmArgs) {
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "addHttpProxySettings"));
        }
        List proxyProperties = HttpConfigurable.getJvmPropertiesList((boolean)false, null);
        AndroidGradleBuildProcessParametersProvider.populateHttpProxyProperties(jvmArgs, proxyProperties);
    }

    @VisibleForTesting
    static void populateHttpProxyProperties(List<String> jvmArgs, List<KeyValue<String, String>> properties) {
        int propertyCount = properties.size();
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.proxy.property.count", (int)propertyCount));
        for (int i = 0; i < propertyCount; ++i) {
            KeyValue<String, String> property = properties.get(i);
            String name = "com.android.studio.gradle.proxy.property." + i;
            String value = (String)property.getKey() + ":" + (String)property.getValue();
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)value));
        }
    }

    private void populateJvmArgs(@NotNull BuildSettings buildSettings, @NotNull List<String> jvmArgs) {
        if (buildSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        BuildMode buildMode = buildSettings.getBuildMode();
        if (buildMode == null) {
            buildMode = BuildMode.DEFAULT_BUILD_MODE;
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.build.mode", (String)buildMode.toString()));
        this.populateModulesToBuild(buildMode, jvmArgs);
    }

    @VisibleForTesting
    void populateModulesToBuild(@NotNull BuildMode buildMode, @NotNull List<String> jvmArgs) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateModulesToBuild"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateModulesToBuild"));
        }
        String[] modulesToBuild = this.getModulesToBuild(buildMode);
        int moduleCount = modulesToBuild == null ? 0 : modulesToBuild.length;
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.modules.count", (int)moduleCount));
        for (int i = 0; i < moduleCount; ++i) {
            String name = "com.android.studio.gradle.modules." + i;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)modulesToBuild[i]));
        }
    }

    @Nullable
    private String[] getModulesToBuild(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getModulesToBuild"));
        }
        if (buildMode.equals((Object)BuildMode.ASSEMBLE_TRANSLATE) || buildMode.equals((Object)BuildMode.ASSEMBLE) && Projects.lastGradleSyncFailed(this.myProject)) {
            return null;
        }
        BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
        return buildSettings.getModulesToBuildNames();
    }
}

