/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;

public class Macros {
    private static final String TEMPLATES_PACKAGE = "";
    private static final String GENERAL_TEMPLATES = "GeneralTemplates";
    private static final String LISTENER_TEMPLATES = "InstallListenerTemplates";
    private static final String ACCESS_TEMPLATES = "AccessTemplates";
    private static final String LAUNCH_ACTIVITY_TEMPLATES = "LaunchActivityTemplates";
    public final PsiMethod defineAssignment;
    public final MultiMatch createIntent;
    public final MultiMatch installClickAndCallMacro;
    public final MultiMatch installItemClickAndCallMacro;
    public final MultiMatch installMenuItemOnGetMenuItemAndLaunchActivityMacro;
    public final MultiMatch defineInnerClassToLaunchActivityMacro;
    public final MultiMatch findViewById;
    public final MultiMatch findFragmentByTag;
    private static Map<Project, Macros> ourProjectToMacros = new IdentityHashMap<Project, Macros>();
    private final Project myProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiMethod[] getMethodsByName(String templateName, String methodName, Project project) {
        PsiMethod[] psiMethodArray;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = facade.getElementFactory();
        ClassLoader classLoader = Macros.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("/navigationTemplates/" + templateName + ".java.template");
        try {
            int available = inputStream.available();
            byte[] buffer = new byte[available];
            assert (available == inputStream.read(buffer));
            String text = new String(buffer);
            int start = text.indexOf("{");
            int end = text.lastIndexOf("}");
            String body = text.substring(start + 1, end);
            PsiClass psiClass = factory.createClassFromText(body, null);
            psiMethodArray = psiClass.findMethodsByName(methodName, false);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return psiMethodArray;
    }

    public static Macros getInstance(Project project) {
        Macros result = ourProjectToMacros.get(project);
        if (result == null) {
            result = new Macros(project);
            ourProjectToMacros.put(project, result);
        }
        return result;
    }

    public MultiMatch createMacro(String methodDefinition) {
        return MultiMatch.create(this.myProject, methodDefinition);
    }

    private Macros(Project project) {
        this.myProject = project;
        this.defineAssignment = Macros.getMethodsByName(GENERAL_TEMPLATES, "defineAssignment", project)[0];
        PsiMethod defineInnerClassMacro = Macros.getMethodsByName(GENERAL_TEMPLATES, "defineInnerClass", project)[0];
        PsiMethod installClickMacro = Macros.getMethodsByName(LISTENER_TEMPLATES, "installClickListener", project)[0];
        PsiMethod installMenuItemClickMacro = Macros.getMethodsByName(LISTENER_TEMPLATES, "installMenuItemClick", project)[0];
        PsiMethod installItemClickMacro = Macros.getMethodsByName(LISTENER_TEMPLATES, "installItemClickListener", project)[0];
        PsiMethod getMenuItemMacro = Macros.getMethodsByName(ACCESS_TEMPLATES, "getMenuItem", project)[0];
        PsiMethod launchActivityMacro = Macros.getMethodsByName(LAUNCH_ACTIVITY_TEMPLATES, "launchActivity", project)[0];
        PsiMethod launchActivityMacro2 = Macros.getMethodsByName(LAUNCH_ACTIVITY_TEMPLATES, "launchActivity", project)[1];
        this.createIntent = this.createMacro("void macro(Context context, Class activityClass) { new Intent(context, activityClass); }");
        this.installClickAndCallMacro = new MultiMatch(installClickMacro);
        this.installItemClickAndCallMacro = new MultiMatch(installItemClickMacro);
        this.findViewById = this.createMacro("void findViewById(int $id) { findViewById(R.id.$id);}");
        this.findFragmentByTag = this.createMacro("void findViewById(void $fragmentManager, int $tag) { $fragmentManager.findFragmentByTag($tag);}");
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro = new MultiMatch(installMenuItemClickMacro);
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro.addSubMacro("$menuItem", getMenuItemMacro);
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro.addSubMacro("$f", launchActivityMacro);
        this.defineInnerClassToLaunchActivityMacro = new MultiMatch(defineInnerClassMacro);
        this.defineInnerClassToLaunchActivityMacro.addSubMacro("$f", launchActivityMacro2);
    }
}

