/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.tools.idea.editors.allocations.AllocationsRowFilter;
import com.android.tools.idea.editors.allocations.AllocationsRowSorter;
import com.android.tools.idea.editors.allocations.AllocationsTableModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.RowSorter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class AllocationsFilterUtil {
    public static void setUpFiltering(final @NotNull JBTable allocationsTable, final @NotNull JBTextField filterField, final @NotNull JBCheckBox includeTraceCheckBox) {
        if (allocationsTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil", "setUpFiltering"));
        }
        if (filterField == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil", "setUpFiltering"));
        }
        if (includeTraceCheckBox == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil", "setUpFiltering"));
        }
        includeTraceCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AllocationsFilterUtil.updateFilter(allocationsTable, filterField, includeTraceCheckBox);
            }
        });
        filterField.getDocument().addDocumentListener(new AllocationsFilterListener(allocationsTable, filterField, includeTraceCheckBox));
    }

    private static void updateFilter(@NotNull JBTable table, @NotNull JBTextField field, @NotNull JBCheckBox checkBox) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil", "updateFilter"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil", "updateFilter"));
        }
        if (checkBox == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil", "updateFilter"));
        }
        RowSorter rowSorter = table.getRowSorter();
        if (rowSorter instanceof AllocationsRowSorter) {
            ((AllocationsRowSorter)rowSorter).setRowFilter(new AllocationsRowFilter((AllocationsTableModel)table.getModel(), field, checkBox));
        }
    }

    private static class AllocationsFilterListener
    implements DocumentListener {
        private JBTable myTable;
        private JBTextField myField;
        private JBCheckBox myCheckBox;

        public AllocationsFilterListener(@NotNull JBTable table, @NotNull JBTextField field, @NotNull JBCheckBox checkBox) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil$AllocationsFilterListener", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil$AllocationsFilterListener", "<init>"));
            }
            if (checkBox == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/allocations/AllocationsFilterUtil$AllocationsFilterListener", "<init>"));
            }
            this.myTable = table;
            this.myField = field;
            this.myCheckBox = checkBox;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AllocationsFilterUtil.updateFilter(this.myTable, this.myField, this.myCheckBox);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AllocationsFilterUtil.updateFilter(this.myTable, this.myField, this.myCheckBox);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AllocationsFilterUtil.updateFilter(this.myTable, this.myField, this.myCheckBox);
        }
    }
}

