/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.tools.idea.editors.allocations.AllocationsEditor;
import com.android.utils.SdkUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AllocationsEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String ID = "allocations-editor";
    @NonNls
    public static final String DOT_ALLOC = ".alloc";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "accept"));
        }
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)DOT_ALLOC);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "createEditor"));
        }
        AllocationsEditor allocationsEditor = new AllocationsEditor(project, file);
        if (allocationsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "createEditor"));
        }
        return allocationsEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "writeState"));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "getEditorTypeId"));
        }
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

