/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageEditorPanel;
import com.android.draw9patch.ui.ImageViewer;
import com.intellij.AppTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NinePatchEditor
implements FileEditor,
ImageViewer.PatchUpdateListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.editors.NinePatchEditor");
    private static final String NAME = "9-Patch";
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private VirtualFile myFile;
    private BufferedImage myBufferedImage;
    private ImageEditorPanel myImageEditorPanel;
    private boolean myDirtyFlag;

    public NinePatchEditor(Project project, VirtualFile file) {
        FileDocumentManagerAdapter saveListener = new FileDocumentManagerAdapter(){

            public void beforeAllDocumentsSaving() {
                try {
                    NinePatchEditor.this.saveFile();
                }
                catch (IOException e) {
                    LOG.error("Unexpected exception while saving 9-patch file", (Throwable)e);
                }
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)saveListener);
        this.myFile = file;
        try {
            this.myBufferedImage = this.loadImage(file);
            this.myImageEditorPanel = new ImageEditorPanel(null, this.myBufferedImage, this.myFile.getName());
            this.myImageEditorPanel.getViewer().addPatchUpdateListener((ImageViewer.PatchUpdateListener)this);
        }
        catch (IOException e) {
            LOG.error("Unexpected exception while reading 9-patch file", (Throwable)e);
        }
    }

    private BufferedImage loadImage(VirtualFile file) throws IOException {
        this.myBufferedImage = ImageIO.read(file.getInputStream());
        if (this.myBufferedImage == null) {
            throw new IOException("Unable to parse file: " + file.getCanonicalPath());
        }
        return GraphicsUtilities.toCompatibleImage((BufferedImage)this.myBufferedImage);
    }

    private void saveFile() throws IOException {
        if (!this.myDirtyFlag) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream((int)this.myFile.getLength());
        ImageIO.write((RenderedImage)this.myBufferedImage, "PNG", stream);
        this.myFile.setBinaryContent(stream.toByteArray());
        this.myDirtyFlag = false;
    }

    @NotNull
    public JComponent getComponent() {
        Object object = this.myImageEditorPanel != null ? this.myImageEditorPanel : new JLabel("Unexpected error while loading 9-patch file. See Event Log for details.");
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/NinePatchEditor", "getComponent"));
        }
        return object;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/NinePatchEditor", "getName"));
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/NinePatchEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/NinePatchEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/NinePatchEditor", "setState"));
        }
    }

    public boolean isModified() {
        return this.myDirtyFlag;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/NinePatchEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/NinePatchEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        try {
            this.saveFile();
        }
        catch (IOException e) {
            LOG.error("Unexpected exception while saving 9-patch file", (Throwable)e);
        }
        if (this.myImageEditorPanel != null) {
            this.myImageEditorPanel.getViewer().removePatchUpdateListener((ImageViewer.PatchUpdateListener)this);
            this.myImageEditorPanel.dispose();
            this.myImageEditorPanel = null;
        }
    }

    public void patchesUpdated() {
        this.myDirtyFlag = true;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/NinePatchEditor", "getUserData"));
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/NinePatchEditor", "putUserData"));
        }
        this.myUserDataHolder.putUserData(key, value);
    }
}

