/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class AutoImportNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.auto.import");
    @NotNull
    private final Project myProject;
    @NotNull
    private final EditorNotifications myNotifications;

    public AutoImportNotificationProvider(@NotNull Project project, @NotNull EditorNotifications notifications) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/AutoImportNotificationProvider", "<init>"));
        }
        if (notifications == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/AutoImportNotificationProvider", "<init>"));
        }
        this.myProject = project;
        this.myNotifications = notifications;
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        GradleProjectSettings settings;
        String name = file.getName();
        if (("build.gradle".equals(name) || "settings.gradle".equals(name)) && (settings = GradleUtil.getGradleProjectSettings(this.myProject)) != null && settings.isUseAutoImport()) {
            return new DisableAutoImportNotificationPanel(settings);
        }
        return null;
    }

    private class DisableAutoImportNotificationPanel
    extends EditorNotificationPanel {
        DisableAutoImportNotificationPanel(final GradleProjectSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/AutoImportNotificationProvider$DisableAutoImportNotificationPanel", "<init>"));
            }
            this.setText("Gradle 'auto-import' will considerably slow down the IDE, due to a known bug.");
            this.createActionLabel("Open bug report", new Runnable(){

                @Override
                public void run() {
                    BrowserUtil.browse((String)"https://code.google.com/p/android/issues/detail?id=59965");
                }
            });
            this.createActionLabel("Disable 'auto-import'", new Runnable(){

                @Override
                public void run() {
                    settings.setUseAutoImport(false);
                    AutoImportNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
        }
    }
}

