/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.error.AnonymousFeedback;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousFeedbackTask
extends Task.Backgroundable {
    private final Consumer<String> myCallback;
    private final Consumer<Exception> myErrorCallback;
    private final Throwable myThrowable;
    private final Map<String, String> myParams;
    private final String myErrorMessage;
    private final String myErrorDescription;
    private final String myAppVersion;

    public AnonymousFeedbackTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @Nullable Throwable throwable, Map<String, String> params, String errorMessage, String errorDescription, String appVersion, Consumer<String> callback, Consumer<Exception> errorCallback) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/diagnostics/error/AnonymousFeedbackTask", "<init>"));
        }
        super(project, title, canBeCancelled);
        this.myThrowable = throwable;
        this.myParams = params;
        this.myErrorMessage = errorMessage;
        this.myErrorDescription = errorDescription;
        this.myAppVersion = appVersion;
        this.myCallback = callback;
        this.myErrorCallback = errorCallback;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/diagnostics/error/AnonymousFeedbackTask", "run"));
        }
        indicator.setIndeterminate(true);
        try {
            String token = AnonymousFeedback.sendFeedback((AnonymousFeedback.HttpConnectionFactory)new ProxyHttpConnectionFactory(), (Throwable)this.myThrowable, this.myParams, (String)this.myErrorMessage, (String)this.myErrorDescription, (String)this.myAppVersion);
            this.myCallback.consume((Object)token);
        }
        catch (Exception e) {
            this.myErrorCallback.consume((Object)e);
        }
    }

    private static class ProxyHttpConnectionFactory
    extends AnonymousFeedback.HttpConnectionFactory {
        private ProxyHttpConnectionFactory() {
        }

        protected HttpURLConnection openHttpConnection(String path) throws IOException {
            return HttpConfigurable.getInstance().openHttpConnection(path);
        }
    }
}

