/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.intellij.android.designer.model.RadViewComponent;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SegmentType
extends Enum<SegmentType> {
    @NotNull
    public static final /* enum */ SegmentType LEFT = new SegmentType();
    @NotNull
    public static final /* enum */ SegmentType TOP = new SegmentType();
    @NotNull
    public static final /* enum */ SegmentType RIGHT = new SegmentType();
    @NotNull
    public static final /* enum */ SegmentType BOTTOM = new SegmentType();
    @NotNull
    public static final /* enum */ SegmentType BASELINE = new SegmentType();
    @NotNull
    public static final /* enum */ SegmentType CENTER_VERTICAL = new SegmentType();
    @NotNull
    public static final /* enum */ SegmentType CENTER_HORIZONTAL = new SegmentType();
    @NotNull
    public static final /* enum */ SegmentType UNKNOWN = new SegmentType();
    private static final /* synthetic */ SegmentType[] $VALUES;

    public static SegmentType[] values() {
        return (SegmentType[])$VALUES.clone();
    }

    public static SegmentType valueOf(String name) {
        return Enum.valueOf(SegmentType.class, name);
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM || this == BASELINE || this == CENTER_HORIZONTAL;
    }

    public int getX(@Nullable RadViewComponent node, @NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/designer/SegmentType", "getX"));
        }
        switch (this) {
            case RIGHT: {
                return bounds.x + bounds.width;
            }
            case TOP: 
            case BOTTOM: 
            case CENTER_VERTICAL: {
                return bounds.x + bounds.width / 2;
            }
            case UNKNOWN: {
                assert (false);
                return bounds.x;
            }
        }
        return bounds.x;
    }

    public int getY(@Nullable RadViewComponent node, @NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/designer/SegmentType", "getY"));
        }
        switch (this) {
            case TOP: {
                return bounds.y;
            }
            case BOTTOM: {
                return bounds.y + bounds.height;
            }
            case BASELINE: {
                int baseline;
                int n = baseline = node != null ? node.getBaseline() : -1;
                if (node == null) {
                    baseline = (int)((float)bounds.height * 0.8f);
                }
                return bounds.y + baseline;
            }
            case UNKNOWN: {
                assert (false);
                return bounds.y;
            }
        }
        return bounds.y + bounds.height / 2;
    }

    public String toString() {
        return this.name();
    }

    @Nullable
    public static SegmentType getHorizontalResizeEdge(int direction) {
        switch (direction) {
            case 2: {
                return BOTTOM;
            }
            case 1: {
                return TOP;
            }
            case 9: {
                return TOP;
            }
            case 10: {
                return BOTTOM;
            }
            case 5: {
                return TOP;
            }
            case 6: {
                return BOTTOM;
            }
            case 3: 
            case 12: {
                assert (false) : direction;
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static SegmentType getVerticalResizeEdge(int direction) {
        switch (direction) {
            case 8: {
                return RIGHT;
            }
            case 4: {
                return LEFT;
            }
            case 9: {
                return RIGHT;
            }
            case 10: {
                return RIGHT;
            }
            case 5: {
                return LEFT;
            }
            case 6: {
                return LEFT;
            }
            case 3: 
            case 12: {
                assert (false) : direction;
                return null;
            }
        }
        return null;
    }

    static {
        $VALUES = new SegmentType[]{LEFT, TOP, RIGHT, BOTTOM, BASELINE, CENTER_VERTICAL, CENTER_HORIZONTAL, UNKNOWN};
    }
}

