/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.hprof;

import com.android.SdkConstants;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.ddms.hprof.SaveHprofDialog;
import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveHprofHandler
implements ClientData.IHprofDumpHandler {
    private final Project myProject;

    public SaveHprofHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/hprof/SaveHprofHandler", "<init>"));
        }
        this.myProject = project;
    }

    public void onSuccess(String remoteFilePath, Client client) {
        this.showError(AndroidBundle.message("android.ddms.actions.dump.hprof.error.unsupported", remoteFilePath));
    }

    public void onSuccess(final byte[] data, Client client) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveHprofDialog dialog = new SaveHprofDialog(SaveHprofHandler.this.myProject);
                if (!dialog.showAndGet()) {
                    return;
                }
                new SaveAndRunHprofConvTask(SaveHprofHandler.this.myProject, dialog.getHprofFile(), dialog.shouldConvertToHprof(), data).queue();
            }
        }, ModalityState.defaultModalityState());
    }

    public void onEndFailure(Client client, String message) {
        this.showError(message);
    }

    private void showError(final String message) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((String)message, (String)AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]));
            }
        });
    }

    private static class SaveAndRunHprofConvTask
    extends Task.Backgroundable {
        private final File myDestination;
        private final boolean myRunHprofConv;
        private final byte[] myData;
        private Exception myException;

        public SaveAndRunHprofConvTask(@Nullable Project project, @NotNull File destination, boolean runHprofConv, @NotNull byte[] data) {
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/ddms/hprof/SaveHprofHandler$SaveAndRunHprofConvTask", "<init>"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/ddms/hprof/SaveHprofHandler$SaveAndRunHprofConvTask", "<init>"));
            }
            super(project, AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]), false);
            this.myDestination = destination;
            this.myRunHprofConv = runHprofConv;
            this.myData = data;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/hprof/SaveHprofHandler$SaveAndRunHprofConvTask", "run"));
            }
            try {
                this.saveAndConvert();
            }
            catch (Exception e) {
                this.myException = e;
            }
        }

        private void saveAndConvert() throws IOException, ExecutionException {
            File androidHprof = this.myRunHprofConv ? FileUtil.createTempFile((String)"android", (String)"hprof") : this.myDestination;
            Files.write((byte[])this.myData, (File)androidHprof);
            if (this.myRunHprofConv) {
                AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
                if (sdkData == null) {
                    throw new ExecutionException("Unable to find path to SDK.");
                }
                String hprofConvPath = new File(sdkData.getLocation(), AndroidCommonUtils.platformToolPath((String)SdkConstants.FN_HPROF_CONV)).getPath();
                ProcessBuilder pb = new ProcessBuilder(hprofConvPath, androidHprof.getAbsolutePath(), this.myDestination.getAbsolutePath());
                BaseOSProcessHandler handler = new BaseOSProcessHandler(pb.start(), "", null);
                final StringBuilder builder = new StringBuilder();
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        builder.append(event.getText());
                    }
                });
                handler.startNotify();
                handler.waitFor();
                int exitCode = handler.getProcess().exitValue();
                if (exitCode != 0) {
                    throw new ExecutionException(builder.toString().trim());
                }
                androidHprof.delete();
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                Messages.showErrorDialog((String)("Unexpected error while saving heap dump: " + this.myException.getMessage()), (String)AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]));
            } else {
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myDestination);
                Notifications.Bus.notify((Notification)new Notification("Android", AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]), AndroidBundle.message("android.ddms.actions.dump.hprof.saved", this.myDestination), NotificationType.INFORMATION));
            }
        }
    }
}

