/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceComboBoxRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.ddms.OpenVmTraceHandler;
import com.android.tools.idea.ddms.ShowAllocationsHandler;
import com.android.tools.idea.ddms.actions.DumpSysActions;
import com.android.tools.idea.ddms.actions.GcAction;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.ddms.actions.ToggleAllocationTrackingAction;
import com.android.tools.idea.ddms.actions.ToggleMethodProfilingAction;
import com.android.tools.idea.ddms.hprof.DumpHprofAction;
import com.android.tools.idea.ddms.hprof.SaveHprofHandler;
import com.android.utils.Pair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements Disposable,
AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final String NO_DEVICES = "No Connected Devices";
    private JPanel myPanel;
    private JComboBox myDevicesComboBox;
    private JBList myClientsList;
    private final DefaultComboBoxModel myComboBoxModel;
    private final SortedListModel<Client> myClientsListModel;
    private boolean myIgnoreListeners;
    private final DeviceContext myDeviceContext;
    private final Project myProject;
    private AndroidDebugBridge myBridge;

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/DevicePanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/ddms/DevicePanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myComboBoxModel = new DefaultComboBoxModel();
        this.myClientsListModel = new SortedListModel((Comparator)new Comparator<Client>(){

            @Override
            public int compare(Client c1, Client c2) {
                String pkg1 = c1.getClientData().getClientDescription();
                String pkg2 = c2.getClientData().getClientDescription();
                if (pkg1 != null && pkg2 != null) {
                    return pkg1.compareTo(pkg2);
                }
                return 0;
            }
        });
        this.myProject = project;
        this.myDeviceContext = context;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        if (!AndroidSdkUtils.activateDdmsIfNecessary(project, new Computable<AndroidDebugBridge>(){

            @Nullable
            public AndroidDebugBridge compute() {
                return AndroidSdkUtils.getDebugBridge(DevicePanel.this.myProject);
            }
        })) {
            this.myBridge = null;
            return;
        }
        this.myBridge = AndroidSdkUtils.getDebugBridge(this.myProject);
        if (this.myBridge == null) {
            return;
        }
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)new OpenVmTraceHandler(project));
        ClientData.setHprofDumpHandler((ClientData.IHprofDumpHandler)new SaveHprofHandler(project));
        ClientData.setAllocationTrackingHandler((ClientData.IAllocationTrackingHandler)new ShowAllocationsHandler(project));
        this.initializeDeviceCombo();
        this.initializeClientsList();
    }

    private void initializeDeviceCombo() {
        this.myDevicesComboBox.setModel(this.myComboBoxModel);
        this.myDevicesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object sel = DevicePanel.this.myDevicesComboBox.getSelectedItem();
                IDevice device = sel instanceof IDevice ? (IDevice)sel : null;
                DevicePanel.this.updateClientsForDevice(device);
                DevicePanel.this.myDeviceContext.fireDeviceSelected(device);
                DevicePanel.this.myDeviceContext.fireClientSelected(null);
            }
        });
        this.myDevicesComboBox.setRenderer(new DeviceComboBoxRenderer());
        IDevice[] devices = this.myBridge.getDevices();
        if (devices.length == 0) {
            this.myComboBoxModel.addElement(NO_DEVICES);
        } else {
            for (IDevice device : devices) {
                this.myComboBoxModel.addElement(device);
            }
        }
        this.myDevicesComboBox.setSelectedIndex(0);
    }

    public void selectDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/DevicePanel", "selectDevice"));
        }
        this.myDevicesComboBox.setSelectedItem(device);
    }

    private void initializeClientsList() {
        this.myClientsList.setModel(this.myClientsListModel);
        this.myClientsList.setSelectionMode(0);
        this.myClientsList.setEmptyText("No debuggable applications");
        this.myClientsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (!(value instanceof Client)) {
                    return;
                }
                Client c = (Client)value;
                ClientData cd = c.getClientData();
                String name = cd.getClientDescription();
                if (name != null) {
                    List<Pair<String, SimpleTextAttributes>> nameComponents = DevicePanel.renderAppName(name);
                    for (Pair<String, SimpleTextAttributes> component : nameComponents) {
                        this.append((String)component.getFirst(), (SimpleTextAttributes)component.getSecond());
                    }
                }
                if (cd.isValidUserId() && cd.getUserId() != 0) {
                    this.append(String.format(" (user %1$d)", cd.getUserId()), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                this.append(String.format(" (%1$d)", cd.getPid()), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        });
        new ListSpeedSearch((JList)this.myClientsList){

            protected boolean isMatchingElement(Object element, String pattern) {
                if (element instanceof Client) {
                    String pkg = ((Client)element).getClientData().getClientDescription();
                    return pkg != null && pkg.contains(pattern);
                }
                return false;
            }
        };
        this.myClientsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || DevicePanel.this.myIgnoreListeners) {
                    return;
                }
                Object sel = DevicePanel.this.myClientsList.getSelectedValue();
                Client c = sel instanceof Client ? (Client)sel : null;
                DevicePanel.this.myDeviceContext.fireClientSelected(c);
            }
        });
    }

    static List<Pair<String, SimpleTextAttributes>> renderAppName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return Collections.singletonList(Pair.of((Object)name, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
        }
        ArrayList<Pair<String, SimpleTextAttributes>> components = new ArrayList<Pair<String, SimpleTextAttributes>>(2);
        components.add(Pair.of((Object)name.substring(0, index + 1), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
        if (index < name.length() - 1) {
            components.add((Pair<String, SimpleTextAttributes>)Pair.of((Object)name.substring(index + 1), (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
        }
        return components;
    }

    public static List<Pair<String, SimpleTextAttributes>> renderDeviceName(IDevice d) {
        String name;
        ArrayList<Pair<String, SimpleTextAttributes>> components = new ArrayList<Pair<String, SimpleTextAttributes>>(3);
        if (d.isEmulator()) {
            String avdName = d.getAvdName();
            if (avdName == null) {
                avdName = "unknown";
            }
            name = String.format("%1$s %2$s ", AndroidBundle.message("android.emulator", new Object[0]), avdName);
        } else {
            name = String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(d, ""), DevicePropertyUtil.getModel(d, ""));
        }
        components.add(Pair.of((Object)name, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
        if (d.getState() != IDevice.DeviceState.ONLINE) {
            String state = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            components.add((Pair<String, SimpleTextAttributes>)Pair.of((Object)state, (Object)SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES));
        }
        components.add(Pair.of((Object)DevicePropertyUtil.getBuild(d), (Object)SimpleTextAttributes.GRAY_ATTRIBUTES));
        return components;
    }

    public void dispose() {
        if (this.myBridge != null) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            this.myBridge = null;
        }
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    public void clientChanged(Client client, int changeMask) {
    }

    public void deviceConnected(final IDevice device) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.myComboBoxModel.removeElement(DevicePanel.NO_DEVICES);
                DevicePanel.this.myComboBoxModel.addElement(device);
            }
        });
    }

    public void deviceDisconnected(final IDevice device) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.myComboBoxModel.removeElement(device);
                if (DevicePanel.this.myComboBoxModel.getSize() == 0) {
                    DevicePanel.this.myComboBoxModel.addElement(DevicePanel.NO_DEVICES);
                }
            }
        });
    }

    public void deviceChanged(final IDevice device, final int changeMask) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.myDevicesComboBox.repaint();
                if (!DevicePanel.this.myDevicesComboBox.getSelectedItem().equals(device)) {
                    return;
                }
                if ((changeMask & 2) == 2) {
                    DevicePanel.this.updateClientsForDevice(device);
                }
                DevicePanel.this.myDeviceContext.fireDeviceChanged(device, changeMask);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClientsForDevice(@Nullable IDevice device) {
        if (device == null) {
            this.myClientsListModel.clear();
            return;
        }
        Object selectedObject = this.myClientsList.getSelectedValue();
        Object[] clients = device.getClients();
        try {
            this.myIgnoreListeners = ArrayUtil.contains((Object)selectedObject, (Object[])clients);
            this.myClientsListModel.clear();
            this.myClientsListModel.addAll(clients);
            this.myClientsList.setSelectedValue(selectedObject, true);
        }
        finally {
            this.myIgnoreListeners = false;
        }
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ScreenshotAction(this.myProject, this.myDeviceContext));
        group.add((AnAction)new ScreenRecorderAction(this.myProject, this.myDeviceContext));
        group.add((AnAction)DumpSysActions.create(this.myProject, this.myDeviceContext));
        group.add((AnAction)new Separator());
        group.add((AnAction)new TerminateVMAction(this.myDeviceContext));
        group.add((AnAction)new GcAction(this.myDeviceContext));
        group.add((AnAction)new DumpHprofAction(this.myDeviceContext));
        group.add((AnAction)new ToggleMethodProfilingAction(this.myProject, this.myDeviceContext));
        group.add((AnAction)new ToggleAllocationTrackingAction(this.myDeviceContext));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePanel", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.myDevicesComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, "North");
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myClientsList = jBList = new JBList();
        DefaultListModel defaultListModel = new DefaultListModel();
        jBList.setModel(defaultListModel);
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

