/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationMenuAction
extends FlatComboAction {
    private final RenderContext myRenderContext;
    private static final int ACTION_ADD = 1;
    private static final int ACTION_DELETE_ALL = 2;
    private static final int ACTION_PREVIEW_MODE = 3;

    public ConfigurationMenuAction(RenderContext renderContext) {
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Configuration to render this layout with in the IDE");
        presentation.setIcon(AndroidIcons.AndroidFile);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup("Configuration", true);
        VirtualFile virtualFile = this.myRenderContext.getVirtualFile();
        if (virtualFile != null) {
            Module module = this.myRenderContext.getModule();
            if (module == null) {
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMenuAction", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }
            Project project = module.getProject();
            List<VirtualFile> variations = ResourceHelper.getResourceVariations(virtualFile, true);
            if (variations.size() > 1) {
                for (VirtualFile file : variations) {
                    String title = String.format("Switch to %1$s", file.getParent().getName());
                    group.add((AnAction)new SwitchToVariationAction(title, project, file, virtualFile == file));
                }
                group.addSeparator();
            }
            boolean haveLandscape = false;
            boolean haveLarge = false;
            for (VirtualFile file : variations) {
                ScreenSizeQualifier size;
                FolderConfiguration config;
                String name = file.getParent().getName();
                if (!name.startsWith("layout") || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                ScreenOrientationQualifier orientation = config.getScreenOrientationQualifier();
                if (orientation != null && orientation.getValue() == ScreenOrientation.LANDSCAPE) {
                    haveLandscape = true;
                    if (haveLarge) break;
                }
                if ((size = config.getScreenSizeQualifier()) == null || size.getValue() != ScreenSize.XLARGE) continue;
                haveLarge = true;
                if (!haveLandscape) continue;
                break;
            }
            if (!haveLandscape) {
                group.add((AnAction)new CreateVariationAction(this.myRenderContext, "Create Landscape Variation", "layout-land"));
            }
            if (!haveLarge) {
                group.add((AnAction)new CreateVariationAction(this.myRenderContext, "Create layout-xlarge Variation", "layout-xlarge"));
            }
            group.add((AnAction)new CreateVariationAction(this.myRenderContext, "Create Other...", null));
            if (this.myRenderContext.supportsPreviews()) {
                this.addMultiConfigActions(group);
            }
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    private void addMultiConfigActions(DefaultActionGroup group) {
        VirtualFile file = this.myRenderContext.getVirtualFile();
        if (file == null) {
            return;
        }
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return;
        }
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        group.addSeparator();
        group.add((AnAction)new PreviewAction(this.myRenderContext, "Preview Representative Sample", 3, RenderPreviewMode.DEFAULT, true));
        ConfigurationMenuAction.addScreenSizeAction(this.myRenderContext, group);
        boolean haveMultipleLocales = configurationManager.getLocales().size() > 1;
        ConfigurationMenuAction.addLocalePreviewAction(this.myRenderContext, group, haveMultipleLocales);
        ConfigurationMenuAction.addRtlPreviewAction(this.myRenderContext, group);
        ConfigurationMenuAction.addApiLevelPreviewAction(this.myRenderContext, group);
        boolean DISABLE_RENDER_INCLUDED = true;
        boolean canPreviewIncluded = !DISABLE_RENDER_INCLUDED && ConfigurationMenuAction.hasCapability(this.myRenderContext, Capability.EMBEDDED_LAYOUT);
        group.add((AnAction)new PreviewAction(this.myRenderContext, "Preview Included", 3, RenderPreviewMode.INCLUDES, canPreviewIncluded));
        List<VirtualFile> variations = ResourceHelper.getResourceVariations(file, true);
        group.add((AnAction)new PreviewAction(this.myRenderContext, "Preview Layout Versions", 3, RenderPreviewMode.VARIATIONS, variations.size() > 1));
        group.add((AnAction)new PreviewAction(this.myRenderContext, "None", 3, RenderPreviewMode.NONE, true));
        group.addSeparator();
        group.add(new AnAction("Toggle Layout Mode"){

            public void actionPerformed(AnActionEvent e) {
                RenderPreviewManager.toggleLayoutMode(ConfigurationMenuAction.this.myRenderContext);
            }
        });
    }

    static void addLocalePreviewAction(@NotNull RenderContext context, @NotNull DefaultActionGroup group, boolean enabled) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addLocalePreviewAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addLocalePreviewAction"));
        }
        group.add((AnAction)new PreviewAction(context, "Preview All Locales", 3, RenderPreviewMode.LOCALES, enabled));
    }

    static void addRtlPreviewAction(@NotNull RenderContext context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRtlPreviewAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRtlPreviewAction"));
        }
        boolean enabled = ConfigurationMenuAction.hasCapability(context, Capability.RTL);
        group.add((AnAction)new PreviewAction(context, "Preview Right-to-Left Layout", 3, RenderPreviewMode.RTL, enabled));
    }

    static void addApiLevelPreviewAction(@NotNull RenderContext context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addApiLevelPreviewAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addApiLevelPreviewAction"));
        }
        boolean enabled = ConfigurationMenuAction.hasCapability(context, Capability.SIMULATE_PLATFORM);
        group.add((AnAction)new PreviewAction(context, "Preview Android Versions", 3, RenderPreviewMode.API_LEVELS, enabled));
    }

    private static boolean hasCapability(RenderContext context, Capability capability) {
        ConfigurationManager configurationManager;
        IAndroidTarget target;
        boolean enabled = false;
        Configuration configuration = context.getConfiguration();
        Module module = context.getModule();
        if (configuration != null && module != null && (target = (configurationManager = configuration.getConfigurationManager()).getTarget()) != null) {
            LayoutLibrary library = RenderService.getLayoutLibrary(module, target);
            enabled = library != null && library.supports(capability);
        }
        return enabled;
    }

    static void addScreenSizeAction(@NotNull RenderContext context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addScreenSizeAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addScreenSizeAction"));
        }
        group.add((AnAction)new PreviewAction(context, "Preview All Screen Sizes", 3, RenderPreviewMode.SCREENS, true));
    }

    static void addRemovePreviewsAction(@NotNull RenderContext context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRemovePreviewsAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRemovePreviewsAction"));
        }
        group.add((AnAction)new PreviewAction(context, "Remove Previews", 3, RenderPreviewMode.NONE, true));
    }

    private static class CreateVariationAction
    extends AnAction {
        @NotNull
        private RenderContext myRenderContext;
        @Nullable
        private String myNewFolder;

        public CreateVariationAction(@NotNull RenderContext renderContext, @NotNull String title, @Nullable String newFolder) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/ConfigurationMenuAction$CreateVariationAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction$CreateVariationAction", "<init>"));
            }
            super(title, null, null);
            this.myRenderContext = renderContext;
            this.myNewFolder = newFolder;
        }

        public void actionPerformed(AnActionEvent e) {
            OverrideResourceAction.forkResourceFile(this.myRenderContext, this.myNewFolder, true);
        }
    }

    private static class SwitchToVariationAction
    extends AnAction {
        private final Project myProject;
        private final VirtualFile myFile;

        public SwitchToVariationAction(String title, @NotNull Project project, VirtualFile file, boolean select) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction$SwitchToVariationAction", "<init>"));
            }
            super(title, null, null);
            this.myFile = file;
            this.myProject = project;
            if (select) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.setIcon(AllIcons.Actions.Checked);
                templatePresentation.setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myFile, -1);
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
        }
    }

    private static class PreviewAction
    extends AnAction {
        private final int myAction;
        private final RenderPreviewMode myMode;
        private final RenderContext myRenderContext;

        public PreviewAction(@NotNull RenderContext renderContext, @NotNull String title, int action, @Nullable RenderPreviewMode mode, boolean enabled) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/ConfigurationMenuAction$PreviewAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/ConfigurationMenuAction$PreviewAction", "<init>"));
            }
            super(title, null, null);
            this.myRenderContext = renderContext;
            this.myAction = action;
            this.myMode = mode;
            if (mode != null && mode == RenderPreviewMode.getCurrent()) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.setIcon(AllIcons.Actions.Checked);
                templatePresentation.setEnabled(false);
            }
            if (!enabled) {
                this.getTemplatePresentation().setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            RenderPreviewManager previewManager = this.myRenderContext.getPreviewManager(true);
            assert (previewManager != null);
            switch (this.myAction) {
                case 1: {
                    previewManager.addAsThumbnail();
                    break;
                }
                case 3: {
                    assert (this.myMode != null);
                    previewManager.selectMode(this.myMode);
                    break;
                }
                case 2: {
                    previewManager.deleteManualPreviews();
                    break;
                }
                default: {
                    assert (false) : this.myAction;
                    break;
                }
            }
            this.myRenderContext.updateLayout();
        }
    }
}

