/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.LayoutDirection;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.base.Objects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration
implements Disposable {
    @Nullable
    VirtualFile myFile;
    @NotNull
    protected final FolderConfiguration myFullConfig;
    @NotNull
    protected final ConfigurationManager myManager;
    @NotNull
    protected final FolderConfiguration myEditedConfig;
    @Nullable
    private IAndroidTarget myTarget;
    @Nullable
    private String myTheme;
    @Nullable
    private Device mySpecificDevice;
    @Nullable
    private State myState;
    @Nullable
    private Device myDevice;
    @Nullable
    private String myStateName;
    @Nullable
    private String myActivity;
    @Nullable
    private Locale myLocale;
    @NotNull
    private UiMode myUiMode;
    @NotNull
    private NightMode myNightMode;
    private String myDisplayName;
    private int myBulkEditingCount;
    @Nullable
    private List<ConfigurationListener> myListeners;
    protected int myNotifyDirty;
    protected int myFolderConfigDirty;
    protected int myProjectStateVersion;
    private static final String NO_ACTIVITY = new String();

    protected Configuration(@NotNull ConfigurationManager manager, @Nullable VirtualFile file, @NotNull FolderConfiguration editedConfig) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "<init>"));
        }
        if (editedConfig == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/configurations/Configuration", "<init>"));
        }
        this.myFullConfig = new FolderConfiguration();
        this.myLocale = null;
        this.myUiMode = UiMode.NORMAL;
        this.myNightMode = NightMode.NOTNIGHT;
        this.myFolderConfigDirty = 246;
        this.myManager = manager;
        this.myFile = file;
        this.myEditedConfig = editedConfig;
        if (this.isLocaleSpecificLayout()) {
            this.myLocale = Locale.create(editedConfig);
        }
        if (this.isOrientationSpecificLayout()) {
            ScreenOrientationQualifier qualifier = editedConfig.getScreenOrientationQualifier();
            assert (qualifier != null);
            ScreenOrientation orientation = qualifier.getValue();
            if (orientation != null) {
                this.myStateName = orientation.getShortDisplayValue();
            }
        }
    }

    @NotNull
    static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file, @NotNull FolderConfiguration editedConfig) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        if (editedConfig == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        Configuration configuration = new Configuration(manager, file, editedConfig);
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        return configuration;
    }

    @NotNull
    public static Configuration create(@NotNull Configuration base, @NotNull VirtualFile file) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        Configuration configuration = base.clone();
        AppResourceRepository resources = AppResourceRepository.getAppResources(base.getModule(), true);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, resources, file);
        configuration.getEditedConfig().set(FolderConfiguration.getConfigForFolder((String)file.getParent().getName()));
        matcher.adaptConfigSelection(true);
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        return configuration2;
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file, @Nullable ConfigurationFileState fileState, @NotNull FolderConfiguration editedConfig) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        if (editedConfig == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        Configuration configuration = new Configuration(manager, file, editedConfig);
        configuration.startBulkEditing();
        if (fileState != null) {
            fileState.loadState(configuration);
        }
        configuration.finishBulkEditing();
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "create"));
        }
        return configuration2;
    }

    @NotNull
    public static Configuration copy(@NotNull Configuration original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "copy"));
        }
        FolderConfiguration copiedConfig = new FolderConfiguration();
        copiedConfig.set(original.getEditedConfig());
        Configuration copy = new Configuration(original.myManager, original.myFile, copiedConfig);
        copy.myFullConfig.set(original.myFullConfig);
        copy.myFolderConfigDirty = original.myFolderConfigDirty;
        copy.myProjectStateVersion = original.myProjectStateVersion;
        copy.myTarget = original.myTarget;
        copy.myLocale = original.myLocale;
        copy.myTheme = original.getTheme();
        copy.mySpecificDevice = original.mySpecificDevice;
        copy.myDevice = original.myDevice;
        copy.myStateName = original.myStateName;
        copy.myState = original.myState;
        copy.myActivity = original.getActivity();
        copy.myUiMode = original.getUiMode();
        copy.myNightMode = original.getNightMode();
        copy.myDisplayName = original.getDisplayName();
        Configuration configuration = copy;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "copy"));
        }
        return configuration;
    }

    public Configuration clone() {
        return Configuration.copy(this);
    }

    @NotNull
    public static Configuration copyCompatible(@NotNull Configuration source, @NotNull Configuration destination) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "copyCompatible"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/Configuration", "copyCompatible"));
        }
        assert (source.myFile != destination.myFile);
        FolderConfiguration editedConfig = destination.getEditedConfig();
        if (editedConfig.getVersionQualifier() == null) {
            destination.myTarget = source.myTarget;
        }
        if (editedConfig.getScreenSizeQualifier() == null) {
            destination.mySpecificDevice = source.mySpecificDevice;
        }
        if (editedConfig.getScreenOrientationQualifier() == null && editedConfig.getSmallestScreenWidthQualifier() == null) {
            destination.myStateName = source.myStateName;
            destination.myState = source.myState;
        }
        if (editedConfig.getLanguageQualifier() == null) {
            destination.myLocale = source.myLocale;
        }
        if (editedConfig.getUiModeQualifier() == null) {
            destination.myUiMode = source.getUiMode();
        }
        if (editedConfig.getNightModeQualifier() == null) {
            destination.myNightMode = source.getNightMode();
        }
        destination.myActivity = source.getActivity();
        destination.myTheme = source.getTheme();
        AppResourceRepository resources = AppResourceRepository.getAppResources(source.myManager.getModule(), true);
        ConfigurationMatcher matcher = new ConfigurationMatcher(destination, resources, destination.myFile);
        matcher.adaptConfigSelection(true);
        Configuration configuration = destination;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "copyCompatible"));
        }
        return configuration;
    }

    public void save() {
        ConfigurationStateManager stateManager = ConfigurationStateManager.get(this.myManager.getModule().getProject());
        if (this.myFile != null) {
            ConfigurationFileState fileState = new ConfigurationFileState();
            fileState.saveState(this);
            stateManager.setConfigurationState(this.myFile, fileState);
        }
    }

    @NotNull
    public ConfigurationManager getConfigurationManager() {
        ConfigurationManager configurationManager = this.myManager;
        if (configurationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getConfigurationManager"));
        }
        return configurationManager;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public String getActivity() {
        if (this.myActivity == NO_ACTIVITY) {
            return null;
        }
        if (this.myActivity == null && this.myFile != null) {
            this.myActivity = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    XmlAttribute attribute;
                    XmlFile xmlFile;
                    XmlTag rootTag;
                    PsiFile file = PsiManager.getInstance((Project)Configuration.this.myManager.getProject()).findFile(Configuration.this.myFile);
                    if (file instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)file).getRootTag()) != null && (attribute = rootTag.getAttribute("context", "http://schemas.android.com/tools")) != null) {
                        return attribute.getValue();
                    }
                    return null;
                }
            });
            if (this.myActivity == null) {
                this.myActivity = NO_ACTIVITY;
                return null;
            }
        }
        return this.myActivity;
    }

    @Nullable
    public Device getDevice() {
        if (this.myDevice == null) {
            this.myDevice = this.mySpecificDevice != null ? this.mySpecificDevice : this.computeBestDevice();
        }
        return this.myDevice;
    }

    @Nullable
    public static FolderConfiguration getFolderConfig(@NotNull Module module, @NotNull State state, @NotNull Locale locale, @Nullable IAndroidTarget target) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "getFolderConfig"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/Configuration", "getFolderConfig"));
        }
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/configurations/Configuration", "getFolderConfig"));
        }
        FolderConfiguration currentConfig = DeviceConfigHelper.getFolderConfig((State)state);
        if (currentConfig != null && locale.hasLanguage()) {
            LayoutLibrary layoutLib;
            currentConfig.setLanguageQualifier(locale.language);
            if (locale.hasRegion()) {
                currentConfig.setRegionQualifier(locale.region);
            }
            if (locale.hasLanguage() && (layoutLib = RenderService.getLayoutLibrary(module, target)) != null && layoutLib.isRtl(locale.toLocaleId())) {
                currentConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
            }
        }
        return currentConfig;
    }

    @Nullable
    private Device computeBestDevice() {
        for (Device device : this.myManager.getRecentDevices()) {
            ResourceType type;
            VirtualFile match;
            List types;
            ResourceFolderType folderType;
            AppResourceRepository resources;
            String stateName = this.myStateName;
            if (stateName == null) {
                stateName = device.getDefaultState().getName();
            }
            State selectedState = ConfigurationFileState.getState(device, stateName);
            Module module = this.myManager.getModule();
            FolderConfiguration currentConfig = Configuration.getFolderConfig(module, selectedState, this.getLocale(), this.getTarget());
            if (currentConfig == null || !this.myEditedConfig.isMatchFor(currentConfig) || (resources = AppResourceRepository.getAppResources(module, true)) == null || this.myFile == null || (folderType = ResourceHelper.getFolderType(this.myFile)) == null || (types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty() || (match = resources.getMatchingFile(this.myFile, type = (ResourceType)types.get(0), currentConfig)) == null || !this.myFile.equals(match)) continue;
            return device;
        }
        return this.myManager.getDefaultDevice();
    }

    @Nullable
    public State getDeviceState() {
        if (this.myState == null) {
            Device device = this.getDevice();
            this.myState = ConfigurationFileState.getState(device, this.myStateName);
        }
        return this.myState;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            Locale locale = this.myManager.getLocale();
            if (locale == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getLocale"));
            }
            return locale;
        }
        Locale locale = this.myLocale;
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getLocale"));
        }
        return locale;
    }

    @NotNull
    public UiMode getUiMode() {
        UiMode uiMode = this.myUiMode;
        if (uiMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getUiMode"));
        }
        return uiMode;
    }

    @NotNull
    public NightMode getNightMode() {
        NightMode nightMode = this.myNightMode;
        if (nightMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getNightMode"));
        }
        return nightMode;
    }

    @Nullable
    public String getTheme() {
        if (this.myTheme == null) {
            this.myTheme = this.myManager.computePreferredTheme(this);
        }
        return this.myTheme;
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            IAndroidTarget target = this.myManager.getTarget();
            VersionQualifier version = this.myEditedConfig.getVersionQualifier();
            if (target != null && version != null && version.getVersion() > target.getVersion().getFeatureLevel()) {
                return this.myManager.getTarget(version.getVersion());
            }
            return target;
        }
        return this.myTarget;
    }

    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isLocaleSpecificLayout() {
        return this.myEditedConfig.getLanguageQualifier() != null;
    }

    public boolean isTargetSpecificLayout() {
        return this.myEditedConfig.getVersionQualifier() != null;
    }

    public boolean isOrientationSpecificLayout() {
        return this.myEditedConfig.getScreenOrientationQualifier() != null;
    }

    @NotNull
    public FolderConfiguration getFullConfig() {
        if ((this.myFolderConfigDirty & 0xF6) != 0 || this.myProjectStateVersion != this.myManager.getStateVersion()) {
            this.syncFolderConfig();
        }
        FolderConfiguration folderConfiguration = this.myFullConfig;
        if (folderConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getFullConfig"));
        }
        return folderConfiguration;
    }

    public void copyFullConfig(FolderConfiguration dest) {
        dest.set(this.myFullConfig);
    }

    @NotNull
    public FolderConfiguration getEditedConfig() {
        FolderConfiguration folderConfiguration = this.myEditedConfig;
        if (folderConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getEditedConfig"));
        }
        return folderConfiguration;
    }

    public void setActivity(@Nullable String activity) {
        if (!StringUtil.equals((CharSequence)this.myActivity, (CharSequence)activity)) {
            this.myActivity = activity;
            this.updated(256);
        }
    }

    public void setDevice(Device device, boolean preserveState) {
        if (this.mySpecificDevice != device) {
            Device prevDevice = this.mySpecificDevice;
            State prevState = this.myState;
            this.myDevice = this.mySpecificDevice = device;
            int updateFlags = 2;
            if (device != null) {
                State state = null;
                if (preserveState && prevDevice != null) {
                    if (prevState != null) {
                        FolderConfiguration oldConfig = DeviceConfigHelper.getFolderConfig((State)prevState);
                        if (oldConfig != null) {
                            String stateName = Configuration.getClosestMatch(oldConfig, device.getAllStates());
                            state = device.getState(stateName);
                        } else {
                            state = device.getState(prevState.getName());
                        }
                    }
                } else if (preserveState && this.myStateName != null) {
                    state = device.getState(this.myStateName);
                }
                if (state == null) {
                    state = device.getDefaultState();
                }
                if (this.myState != state) {
                    this.setDeviceStateName(state.getName());
                    this.myState = state;
                    updateFlags |= 4;
                }
            }
            if (this.mySpecificDevice != null && this.myState == null) {
                this.setDeviceStateName(this.mySpecificDevice.getDefaultState().getName());
                this.myState = this.mySpecificDevice.getDefaultState();
                updateFlags |= 4;
            }
            this.updated(updateFlags);
        }
    }

    @Nullable
    private static String getClosestMatch(@NotNull FolderConfiguration oldConfig, @NotNull List<State> states) {
        if (oldConfig == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "getClosestMatch"));
        }
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/Configuration", "getClosestMatch"));
        }
        ArrayList<Object> list1 = new ArrayList<Object>(states.size());
        ArrayList<State> list2 = new ArrayList<State>(states.size());
        list1.addAll(states);
        int count = FolderConfiguration.getQualifierCount();
        for (int i = 0; i < count; ++i) {
            for (State state : list1) {
                ResourceQualifier newQualifier;
                ResourceQualifier oldQualifier = oldConfig.getQualifier(i);
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig((State)state);
                ResourceQualifier resourceQualifier = newQualifier = folderConfig != null ? folderConfig.getQualifier(i) : null;
                if (oldQualifier == null) {
                    if (newQualifier != null) continue;
                    list2.add(state);
                    continue;
                }
                if (!oldQualifier.equals((Object)newQualifier)) continue;
                list2.add(state);
            }
            if (list2.size() == 1) {
                return ((State)list2.get(0)).getName();
            }
            if (list2.size() == 0) continue;
            list1.clear();
            list1.addAll(list2);
            list2.clear();
        }
        if (list1.size() > 0) {
            return ((State)list1.get(0)).getName();
        }
        return null;
    }

    public void setDeviceState(State state) {
        if (this.myState != state) {
            if (state != null) {
                this.setDeviceStateName(state.getName());
            } else {
                this.myStateName = null;
            }
            this.myState = state;
            this.updated(4);
        }
    }

    public void setDeviceStateName(@Nullable String stateName) {
        ScreenOrientation orientation;
        ScreenOrientationQualifier qualifier = this.myEditedConfig.getScreenOrientationQualifier();
        if (qualifier != null && (orientation = qualifier.getValue()) != null) {
            stateName = orientation.getShortDisplayValue();
        }
        if (!Objects.equal((Object)stateName, (Object)this.myStateName)) {
            this.myStateName = stateName;
            this.myState = null;
            this.updated(4);
        }
    }

    public void setLocale(@NotNull Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "setLocale"));
        }
        if (!Objects.equal((Object)this.myLocale, (Object)locale)) {
            this.myLocale = locale;
            this.updated(16);
        }
    }

    public void setTarget(@Nullable IAndroidTarget target) {
        if (this.myTarget != target) {
            this.myTarget = target;
            this.updated(32);
        }
    }

    public void setDisplayName(@Nullable String displayName) {
        if (!StringUtil.equals((CharSequence)this.myDisplayName, (CharSequence)displayName)) {
            this.myDisplayName = displayName;
            this.updated(512);
        }
    }

    public void setNightMode(@NotNull NightMode night) {
        if (night == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "setNightMode"));
        }
        if (this.myNightMode != night) {
            this.myNightMode = night;
            this.updated(64);
        }
    }

    public void setUiMode(@NotNull UiMode uiMode) {
        if (uiMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "setUiMode"));
        }
        if (this.myUiMode != uiMode) {
            this.myUiMode = uiMode;
            this.updated(128);
        }
    }

    public void setTheme(@Nullable String theme) {
        if (!StringUtil.equals((CharSequence)this.myTheme, (CharSequence)theme)) {
            this.myTheme = theme;
            this.checkThemePrefix();
            this.updated(8);
        }
    }

    protected void syncFolderConfig() {
        Device device = this.getDevice();
        if (device == null) {
            return;
        }
        State deviceState = this.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        FolderConfiguration config = Configuration.getFolderConfig(this.getModule(), deviceState, this.getLocale(), this.getTarget());
        this.myFullConfig.set(config);
        Locale locale = this.getLocale();
        this.myFullConfig.setLanguageQualifier(locale.language);
        this.myFullConfig.setRegionQualifier(locale.region);
        if (this.myEditedConfig.getLayoutDirectionQualifier() != null) {
            this.myFullConfig.setLayoutDirectionQualifier(this.myEditedConfig.getLayoutDirectionQualifier());
        } else if (!locale.hasLanguage()) {
            this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
        } else {
            LayoutLibrary layoutLib = RenderService.getLayoutLibrary(this.getModule(), this.getTarget());
            if (layoutLib != null) {
                if (layoutLib.isRtl(locale.toLocaleId())) {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
                } else {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
                }
            }
        }
        UiMode uiMode = this.getUiMode();
        this.myFullConfig.setUiModeQualifier(new UiModeQualifier(uiMode));
        NightMode nightMode = this.getNightMode();
        this.myFullConfig.setNightModeQualifier(new NightModeQualifier(nightMode));
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            int apiLevel = target.getVersion().getFeatureLevel();
            this.myFullConfig.setVersionQualifier(new VersionQualifier(apiLevel));
        }
        this.myFolderConfigDirty = 0;
        this.myProjectStateVersion = this.myManager.getStateVersion();
    }

    @Nullable
    public ScreenSize getScreenSize() {
        FolderConfiguration folderConfig;
        State deviceState = this.getDeviceState();
        if (deviceState != null && (folderConfig = DeviceConfigHelper.getFolderConfig((State)deviceState)) != null) {
            ScreenSizeQualifier qualifier = folderConfig.getScreenSizeQualifier();
            assert (qualifier != null);
            return qualifier.getValue();
        }
        ScreenSize screenSize = null;
        Device device = this.getDevice();
        if (device != null) {
            List states = device.getAllStates();
            for (State state : states) {
                FolderConfiguration folderConfig2 = DeviceConfigHelper.getFolderConfig((State)state);
                if (folderConfig2 == null) continue;
                ScreenSizeQualifier qualifier = folderConfig2.getScreenSizeQualifier();
                assert (qualifier != null);
                screenSize = qualifier.getValue();
                break;
            }
        }
        return screenSize;
    }

    private void checkThemePrefix() {
        if (this.myTheme != null && !this.myTheme.startsWith("@")) {
            if (this.myTheme.isEmpty()) {
                this.myTheme = this.myManager.computePreferredTheme(this);
                return;
            }
            this.myTheme = "@style/" + this.myTheme;
        }
    }

    @NotNull
    public Density getDensity() {
        Density d;
        DensityQualifier qualifier = this.myFullConfig.getDensityQualifier();
        if (qualifier != null && (d = qualifier.getValue()) != Density.NODPI) {
            Density density = d;
            if (density == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getDensity"));
            }
            return density;
        }
        Density density = Density.MEDIUM;
        if (density == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/Configuration", "getDensity"));
        }
        return density;
    }

    @Nullable
    public State getNextDeviceState(@Nullable State from) {
        Device device = this.getDevice();
        if (device == null) {
            return null;
        }
        List states = device.getAllStates();
        for (int i = 0; i < states.size(); ++i) {
            if (states.get(i) != from) continue;
            return (State)states.get((i + 1) % states.size());
        }
        if (from != null) {
            String name = from.getName();
            for (int i = 0; i < states.size(); ++i) {
                if (!((State)states.get(i)).getName().equals(name)) continue;
                return (State)states.get((i + 1) % states.size());
            }
        }
        return null;
    }

    public boolean supports(Capability capability) {
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            return RenderService.supportsCapability(this.getModule(), target, capability);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkEditing() {
        Configuration configuration = this;
        synchronized (configuration) {
            ++this.myBulkEditingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkEditing() {
        boolean notify = false;
        Configuration configuration = this;
        synchronized (configuration) {
            --this.myBulkEditingCount;
            if (this.myBulkEditingCount == 0) {
                notify = true;
            }
        }
        if (notify) {
            this.updated(0);
        }
    }

    public void updated(int flags) {
        this.myNotifyDirty |= flags;
        this.myFolderConfigDirty |= flags;
        if (this.myManager.getStateVersion() != this.myProjectStateVersion) {
            this.myNotifyDirty |= 0x32;
            this.myFolderConfigDirty |= 0x32;
            this.myDevice = null;
            this.myState = null;
        }
        if (this.myBulkEditingCount == 0) {
            int changed = this.myNotifyDirty;
            if (this.myListeners != null) {
                for (ConfigurationListener listener : this.myListeners) {
                    listener.changed(changed);
                }
            }
            this.myNotifyDirty = 0;
        }
    }

    public void addListener(@NotNull ConfigurationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "addListener"));
        }
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<ConfigurationListener>();
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull ConfigurationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/Configuration", "removeListener"));
        }
        if (this.myListeners != null) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    @Nullable
    public ResourceResolver getResourceResolver() {
        String theme = this.getTheme();
        if (theme != null) {
            return this.myManager.getResolverCache().getResourceResolver(this.getTarget(), theme, this.getFullConfig());
        }
        return null;
    }

    @Nullable
    public ResourceRepository getFrameworkResources() {
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            return this.myManager.getResolverCache().getFrameworkResources(this.getFullConfig(), target);
        }
        return null;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("display", (Object)this.getDisplayName()).add("theme", (Object)this.getTheme()).add("activity", (Object)this.getActivity()).add("device", (Object)this.getDevice()).add("state", (Object)this.getDeviceState()).add("locale", (Object)this.getLocale()).add("target", (Object)this.getTarget()).add("uimode", (Object)this.getUiMode()).add("nightmode", (Object)this.getNightMode()).toString();
    }

    public Module getModule() {
        return this.myManager.getModule();
    }

    public boolean isBestMatchFor(VirtualFile file, FolderConfiguration config) {
        AppResourceRepository resources = AppResourceRepository.getAppResources(this.getModule(), true);
        return new ConfigurationMatcher(this, resources, file).isCurrentFileBestMatchFor(config);
    }

    public void dispose() {
    }

    public void setEffectiveDevice(@Nullable Device device, @Nullable State state) {
        int updateFlags = 0;
        if (this.myDevice != device) {
            updateFlags = 2;
            this.myDevice = device;
        }
        if (this.myState != state) {
            this.myState = state;
            this.myStateName = state != null ? state.getName() : null;
            updateFlags |= 4;
        }
        if (updateFlags != 0) {
            this.updated(updateFlags);
        }
    }
}

