/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class AndroidShowNavigationEditor
extends AnAction {
    public AndroidShowNavigationEditor() {
        super("Navigation Editor", null, AndroidIcons.NavigationEditor);
    }

    private static VirtualFile mkDirs(VirtualFile dir, String path) throws IOException {
        for (String dirName : path.split("/")) {
            VirtualFile existingDir = dir.findFileByRelativePath(dirName);
            dir = existingDir != null ? existingDir : dir.createChildDirectory(null, dirName);
        }
        return dir;
    }

    public void showNavigationEditor(@Nullable Project project, String dir, final String file) {
        if (project == null) {
            return;
        }
        final VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return;
        }
        final String relativePathOfNavDir = ".navigation/" + dir;
        VirtualFile navFile = baseDir.findFileByRelativePath(relativePathOfNavDir + "/" + file);
        if (navFile == null) {
            navFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    try {
                        VirtualFile dir = AndroidShowNavigationEditor.mkDirs(baseDir, relativePathOfNavDir);
                        return dir.createChildData(null, file);
                    }
                    catch (IOException e) {
                        assert (false);
                        return null;
                    }
                }
            });
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, navFile, 0);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        manager.openEditor(descriptor, true);
        manager.setSelectedEditor(navFile, "navigationeditor");
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        this.showNavigationEditor(project, "raw", "main.nvg.xml");
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(true);
    }
}

