/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.AndroidBuildProjectAction;
import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidBuildModuleAction
extends AndroidBuildProjectAction {
    @NotNull
    private final String myActionName;

    protected AndroidBuildModuleAction(@NotNull CompileActionBase delegate, @NotNull String backupText, @NotNull String actionName) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/actions/AndroidBuildModuleAction", "<init>"));
        }
        if (backupText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/actions/AndroidBuildModuleAction", "<init>"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/actions/AndroidBuildModuleAction", "<init>"));
        }
        super(delegate, backupText);
        this.myActionName = actionName;
    }

    protected void updatePresentation(@NotNull AnActionEvent e) {
        String presentationText;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/actions/AndroidBuildModuleAction", "updatePresentation"));
        }
        DataContext dataContext = e.getDataContext();
        Module[] modules = AndroidBuildModuleAction.getSelectedModules(dataContext);
        int moduleCount = modules == null ? 0 : modules.length;
        boolean hasModules = moduleCount > 0;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(hasModules);
        if (hasModules) {
            String text = this.myActionName + (moduleCount == 1 ? " Module" : " Modules");
            for (int i = 0; i < moduleCount; ++i) {
                if (text.length() > 30) {
                    text = this.myActionName + " Selected Modules";
                    break;
                }
                Module toMake = modules[i];
                if (i != 0) {
                    text = text + ",";
                }
                text = text + " '" + toMake.getName() + "'";
            }
            presentationText = text;
        } else {
            presentationText = this.myActionName;
        }
        presentation.setText(presentationText);
        presentation.setVisible(hasModules || !"ProjectViewPopup".equals(e.getPlace()));
    }

    @Nullable
    private static Module[] getSelectedModules(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/actions/AndroidBuildModuleAction", "getSelectedModules"));
        }
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules != null) {
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            return new Module[]{module};
        }
        return null;
    }
}

