/*
 * Decompiled with CFR 0.152.
 */
package com.android.navigation;

import com.android.annotations.NonNull;
import com.android.annotations.Transient;
import com.android.navigation.ActivityState;
import com.android.navigation.Entry;
import com.android.navigation.EventDispatcher;
import com.android.navigation.MenuState;
import com.android.navigation.Point;
import com.android.navigation.State;
import com.android.navigation.Transition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NavigationModel {
    private final EventDispatcher<Event> listeners = new EventDispatcher();
    private final ArrayList<State> states = new ArrayList();
    private final ArrayList<Transition> transitions = new ArrayList();
    private final Map<State, Point> stateToLocation = new HashMap<State, Point>();

    @Transient
    public ArrayList<State> getStates() {
        return this.states;
    }

    @Transient
    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    @Transient
    public Map<State, Point> getStateToLocation() {
        return this.stateToLocation;
    }

    private static Entry<State, Point> toEntry(Map.Entry<State, Point> entry) {
        return new Entry<State, Point>(entry.getKey(), entry.getValue());
    }

    public Collection<Entry<State, Point>> getLocations() {
        ArrayList<Entry<State, Point>> result = new ArrayList<Entry<State, Point>>();
        for (Map.Entry<State, Point> entry : this.stateToLocation.entrySet()) {
            result.add(NavigationModel.toEntry(entry));
        }
        return result;
    }

    public void setLocations(Collection<Entry<State, Point>> locations) {
        for (Entry<State, Point> entry : locations) {
            this.stateToLocation.put((State)entry.key, (Point)entry.value);
        }
    }

    public void addState(State state) {
        if (this.states.contains(state)) {
            return;
        }
        this.states.add(state);
        this.listeners.notify(Event.insert(State.class));
    }

    public void removeState(State state) {
        this.states.remove(state);
        for (Transition t : new ArrayList<Transition>(this.transitions)) {
            if (t.getSource().getState() != state && t.getDestination().getState() != state) continue;
            this.remove(t);
        }
        this.listeners.notify(Event.delete(State.class));
    }

    private void updateStates(State state) {
        if (!this.states.contains(state)) {
            this.states.add(state);
        }
    }

    public boolean add(Transition transition) {
        boolean result = this.transitions.add(transition);
        this.updateStates(transition.getSource().getState());
        this.updateStates(transition.getDestination().getState());
        this.listeners.notify(Event.insert(Transition.class));
        return result;
    }

    public boolean remove(Transition transition) {
        boolean result = this.transitions.remove(transition);
        this.listeners.notify(Event.delete(Transition.class));
        return result;
    }

    @Transient
    public Map<String, ActivityState> getActivities() {
        HashMap<String, ActivityState> activities = new HashMap<String, ActivityState>();
        for (State state : this.states) {
            if (!(state instanceof ActivityState)) continue;
            ActivityState activityState = (ActivityState)state;
            activities.put(activityState.getClassName(), activityState);
        }
        return activities;
    }

    @Transient
    public Map<String, MenuState> getMenus() {
        HashMap<String, MenuState> menus = new HashMap<String, MenuState>();
        for (State state : this.states) {
            if (!(state instanceof MenuState)) continue;
            MenuState menuState = (MenuState)state;
            menus.put(menuState.getXmlResourceName(), menuState);
        }
        return menus;
    }

    public void clear() {
        this.states.clear();
        this.transitions.clear();
        this.listeners.notify(Event.delete(Object.class));
    }

    @Transient
    public EventDispatcher<Event> getListeners() {
        return this.listeners;
    }

    public static class Event {
        public final Operation operation;
        public final Class<?> operandType;

        public Event(@NonNull Operation operation, @NonNull Class operandType) {
            this.operation = operation;
            this.operandType = operandType;
        }

        public static Event of(@NonNull Operation operation, @NonNull Class operandType) {
            return new Event(operation, operandType);
        }

        public static Event insert(@NonNull Class operandType) {
            return Event.of(Operation.INSERT, operandType);
        }

        public static Event update(@NonNull Class operandType) {
            return Event.of(Operation.UPDATE, operandType);
        }

        public static Event delete(@NonNull Class operandType) {
            return Event.of(Operation.DELETE, operandType);
        }

        public static enum Operation {
            INSERT,
            UPDATE,
            DELETE;

        }
    }
}

