/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util.dynamicMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrDynamicPropertyImpl
extends LightElement
implements GrField {
    private final GrField myField;
    private final PsiClass myContainingClass;
    private final PsiElement myNavigationalElement;

    public GrDynamicPropertyImpl(PsiClass containingClass, GrField field, PsiElement navigationalElement) {
        super(field.getManager(), field.getLanguage());
        this.myContainingClass = containingClass;
        this.myNavigationalElement = navigationalElement != null ? navigationalElement : field;
        this.myField = field;
    }

    @Override
    public GrDocComment getDocComment() {
        return null;
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myNavigationalElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    public Icon getIcon(int flags) {
        return JetgroovyIcons.Groovy.Property;
    }

    public PsiFile getContainingFile() {
        return this.myContainingClass != null ? this.myContainingClass.getContainingFile() : null;
    }

    public String toString() {
        return "Dynamic Property: " + this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myField.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myField.getType();
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "getType"));
        }
        return psiType;
    }

    @Override
    public GrModifierList getModifierList() {
        return this.myField.getModifierList();
    }

    public PsiTypeElement getTypeElement() {
        return this.myField.getTypeElement();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "hasModifierProperty"));
        }
        return this.myField.hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return this.myField.getInitializer();
    }

    public void setInitializer(@Nullable PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set initializer");
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = this.myField.getNameIdentifier();
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    public boolean hasInitializer() {
        return this.myField.hasInitializer();
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        throw new IncorrectOperationException("cannot normalize declaration");
    }

    public Object computeConstantValue() {
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "setName"));
        }
        return this;
    }

    public String getText() {
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "accept"));
        }
    }

    public PsiElement copy() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.myField.getNameIdentifierGroovy();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "getNameIdentifierGroovy"));
        }
        return psiElement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
    }

    @Override
    public PsiType getTypeGroovy() {
        return this.myField.getTypeGroovy();
    }

    @Override
    public PsiType getDeclaredType() {
        return this.myField.getDeclaredType();
    }

    @Override
    public boolean isProperty() {
        return this.myField.isProperty();
    }

    @Override
    public GrExpression getInitializerGroovy() {
        return this.myField.getInitializerGroovy();
    }

    @Override
    public void setType(@Nullable PsiType type) throws IncorrectOperationException {
        throw new IncorrectOperationException("cannot set type to dynamic property");
    }

    @Override
    public GrAccessorMethod getSetter() {
        return this.myField.getSetter();
    }

    @Override
    @NotNull
    public GrAccessorMethod[] getGetters() {
        GrAccessorMethod[] grAccessorMethodArray = this.myField.getGetters();
        if (grAccessorMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "getGetters"));
        }
        return grAccessorMethodArray;
    }

    @Override
    public GrTypeElement getTypeElementGroovy() {
        return this.myField.getTypeElementGroovy();
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        Map<String, NamedArgumentDescriptor> map = this.myField.getNamedParameters();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/dynamicMembers/GrDynamicPropertyImpl", "getNamedParameters"));
        }
        return map;
    }

    @Override
    public void setInitializerGroovy(GrExpression initializer) {
        throw new IncorrectOperationException("cannot set initializer to dynamic property!");
    }

    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof GrDynamicPropertyImpl && this.myManager.areElementsEquivalent((PsiElement)this.myField, (PsiElement)((GrDynamicPropertyImpl)another).myField) && this.myManager.areElementsEquivalent((PsiElement)this.myContainingClass, (PsiElement)((GrDynamicPropertyImpl)another).myContainingClass);
    }
}

