/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.testIntegration;

import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GroovyTestFramework
extends JavaTestFramework {
    private static final Logger LOG = Logger.getInstance(GroovyTestFramework.class);

    protected String getMarkerClassFQName() {
        return "groovy.util.GroovyTestCase";
    }

    protected boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        return clazz.getLanguage() == GroovyFileType.GROOVY_LANGUAGE && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"groovy.util.GroovyTestCase");
    }

    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/testIntegration/GroovyTestFramework", "findSetUpMethod"));
        }
        if (!this.isTestClass(clazz, false)) {
            return null;
        }
        for (PsiMethod method : clazz.getMethods()) {
            if (!method.getName().equals("setUp")) continue;
            return method;
        }
        return null;
    }

    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/testIntegration/GroovyTestFramework", "findTearDownMethod"));
        }
        if (!this.isTestClass(clazz, false)) {
            return null;
        }
        for (PsiMethod method : clazz.getMethods()) {
            if (!method.getName().equals("tearDown")) continue;
            return method;
        }
        return null;
    }

    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod inClass;
        PsiMethod baseMethod;
        LOG.assertTrue(clazz.getLanguage() == GroovyFileType.GROOVY_LANGUAGE);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(clazz.getProject());
        PsiMethod patternMethod = this.createSetUpPatternMethod(factory);
        PsiClass baseClass = clazz.getSuperClass();
        if (baseClass != null && (baseMethod = baseClass.findMethodBySignature(patternMethod, false)) != null && baseMethod.hasModifierProperty("public")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"protected", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"public", (boolean)true);
        }
        if ((inClass = clazz.findMethodBySignature(patternMethod, false)) == null) {
            PsiMethod testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz);
            if (testMethod != null) {
                return (PsiMethod)clazz.addBefore((PsiElement)patternMethod, (PsiElement)testMethod);
            }
            return (PsiMethod)clazz.add((PsiElement)patternMethod);
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public char getMnemonic() {
        return 'G';
    }

    @NotNull
    public String getName() {
        if ("Groovy JUnit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/testIntegration/GroovyTestFramework", "getName"));
        }
        return "Groovy JUnit";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JetgroovyIcons.Groovy.Groovy_16x16;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/testIntegration/GroovyTestFramework", "getIcon"));
        }
        return icon;
    }

    public String getLibraryPath() {
        return GroovyUtils.getBundledGroovyJar().getAbsolutePath();
    }

    public String getDefaultSuperClass() {
        return "groovy.util.GroovyTestCase";
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit Test Case.groovy");
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit SetUp Method.groovy");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit TearDown Method.groovy");
    }

    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Groovy JUnit Test Method.groovy");
    }

    public boolean isTestMethod(PsiElement element) {
        return element instanceof PsiMethod && JUnitUtil.getTestMethod((PsiElement)element) != null;
    }

    @NotNull
    public Language getLanguage() {
        Language language = GroovyFileType.GROOVY_LANGUAGE;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/testIntegration/GroovyTestFramework", "getLanguage"));
        }
        return language;
    }
}

