/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

public class GroovyRunnerUtil {
    @Nullable
    public static PsiClass getRunningClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        while (clazz != null) {
            if (GroovyRunnerUtil.canBeRunByGroovy(clazz)) {
                return clazz;
            }
            clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)clazz, PsiClass.class);
        }
        if (((GroovyFile)file).isScript()) {
            return ((GroovyFile)file).getScriptClass();
        }
        PsiClass[] classes = ((GroovyFile)file).getClasses();
        if (classes.length > 0) {
            return classes[0];
        }
        return null;
    }

    public static boolean isRunnable(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        PsiClass runnable = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.lang.Runnable", psiClass.getResolveScope());
        if (runnable == null) {
            return false;
        }
        return psiClass instanceof GrTypeDefinition && !(psiClass instanceof PsiAnonymousClass) && !psiClass.isInterface() && psiClass.isInheritor(runnable, true);
    }

    public static boolean canBeRunByGroovy(PsiClass psiClass) {
        return psiClass instanceof GroovyScriptClass || GroovyRunnerUtil.isRunnable(psiClass) || psiClass instanceof GrTypeDefinition && PsiMethodUtil.hasMainMethod((PsiClass)psiClass);
    }

    public static String getConfigurationName(PsiClass aClass, RunConfigurationModule module) {
        String qualifiedName = aClass.getQualifiedName();
        Project project = module.getProject();
        if (qualifiedName == null) {
            return module.getModuleName();
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName.replace('$', '.'), GlobalSearchScope.projectScope((Project)project));
        if (psiClass != null) {
            return psiClass.getName();
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot == -1 || lastDot == qualifiedName.length() - 1) {
            return qualifiedName;
        }
        return qualifiedName.substring(lastDot + 1, qualifiedName.length());
    }
}

