/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameAliasedUsagesUtil;
import org.jetbrains.plugins.groovy.refactoring.rename.RenamePropertyUtil;

public class RenameGrFieldProcessor
extends RenameJavaVariableProcessor {
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        GrAccessorMethod[] getters;
        assert (element instanceof GrField);
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        GrField field = (GrField)element;
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(MethodReferencesSearch.search((PsiMethod)setter, (SearchScope)projectScope, (boolean)true).findAll(), (PsiElement)setter));
        }
        for (GrAccessorMethod getter : getters = field.getGetters()) {
            refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(MethodReferencesSearch.search((PsiMethod)getter, (SearchScope)projectScope, (boolean)true).findAll(), (PsiElement)getter));
        }
        refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(ReferencesSearch.search((PsiElement)field, (SearchScope)projectScope, (boolean)false).findAll(), field));
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/rename/RenameGrFieldProcessor", "findReferences"));
        }
        return arrayList;
    }

    public void renameElement(PsiElement psiElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        GrField field = (GrField)psiElement;
        String fieldName = field.getName();
        HashMap renames = new HashMap();
        renames.put(field, newName);
        for (GrAccessorMethod getter : field.getGetters()) {
            renames.put(getter, RenamePropertyUtil.getGetterNameByOldName(newName, getter.getName()));
        }
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            renames.put(setter, GroovyPropertyUtils.getSetterName(newName));
        }
        MultiMap propertyUsages = MultiMap.createLinked();
        MultiMap simpleUsages = MultiMap.createLinked();
        ArrayList<PsiReference> unknownUsages = new ArrayList<PsiReference>();
        for (UsageInfo usage : usages) {
            PsiReference ref = usage.getReference();
            if (ref instanceof GrReferenceExpression) {
                GroovyResolveResult resolveResult = ((GrReferenceExpression)ref).advancedResolve();
                PsiElement element = resolveResult.getElement();
                if (resolveResult.isInvokedOnProperty()) {
                    if (element == null) {
                        unknownUsages.add(ref);
                        continue;
                    }
                    propertyUsages.putValue((Object)((PsiNamedElement)element), (Object)usage);
                    continue;
                }
                simpleUsages.putValue((Object)((PsiNamedElement)element), (Object)usage);
                continue;
            }
            if (ref == null) continue;
            unknownUsages.add(ref);
        }
        for (PsiReference ref : unknownUsages) {
            RenameGrFieldProcessor.handleElementRename(newName, ref, fieldName);
        }
        field.setName(newName);
        GrAccessorMethod[] newGetters = field.getGetters();
        GrAccessorMethod newSetter = field.getSetter();
        HashMap newElements = new HashMap();
        newElements.put(newName, field);
        for (GrAccessorMethod newGetter : newGetters) {
            newElements.put(newGetter.getName(), newGetter);
        }
        if (newSetter != null) {
            newElements.put(newSetter.getName(), newSetter);
        }
        PsiManager manager = field.getManager();
        for (PsiNamedElement element : simpleUsages.keySet()) {
            for (UsageInfo info : simpleUsages.get((Object)element)) {
                String name = (String)renames.get(element);
                RenameGrFieldProcessor.rename((PsiNamedElement)newElements.get(name), info, name == null ? newName : name, name != null, manager);
            }
        }
        for (PsiNamedElement element : propertyUsages.keySet()) {
            for (UsageInfo info : propertyUsages.get((Object)element)) {
                RenameGrFieldProcessor.rename(element, info, newName, true, manager);
            }
        }
        if (listener != null) {
            listener.elementRenamed((PsiElement)field);
        }
    }

    private static void rename(PsiNamedElement element, UsageInfo info, String nameToUse, boolean shouldCheckForCorrectResolve, PsiManager manager) {
        PsiReference ref = info.getReference();
        PsiElement renamed = ((GrReferenceExpression)ref).handleElementRenameSimple(nameToUse);
        PsiElement newly_resolved = ref.resolve();
        if (shouldCheckForCorrectResolve) {
            if (element instanceof GrAccessorMethod && newly_resolved instanceof GrAccessorMethod) {
                GrAccessorMethod oldAccessor = (GrAccessorMethod)element;
                GrAccessorMethod newAccessor = (GrAccessorMethod)newly_resolved;
                if (!manager.areElementsEquivalent((PsiElement)oldAccessor.getProperty(), (PsiElement)newAccessor.getProperty()) && oldAccessor.isSetter() == newAccessor.isSetter()) {
                    RenameGrFieldProcessor.qualify((PsiMember)oldAccessor, renamed, nameToUse);
                }
            } else if (!manager.areElementsEquivalent((PsiElement)element, newly_resolved)) {
                RenameGrFieldProcessor.qualify((PsiMember)element, renamed, nameToUse);
            }
        }
    }

    private static void handleElementRename(String newName, PsiReference ref, String fieldName) {
        String refText = ref instanceof PsiQualifiedReference ? ((PsiQualifiedReference)ref).getReferenceName() : ref.getCanonicalText();
        String toRename = fieldName.equals(refText) ? newName : (GroovyPropertyUtils.getGetterNameNonBoolean(fieldName).equals(refText) ? GroovyPropertyUtils.getGetterNameNonBoolean(newName) : (GroovyPropertyUtils.getGetterNameBoolean(fieldName).equals(refText) ? GroovyPropertyUtils.getGetterNameBoolean(newName) : (GroovyPropertyUtils.getSetterName(fieldName).equals(refText) ? GroovyPropertyUtils.getSetterName(newName) : newName)));
        ref.handleElementRename(toRename);
    }

    private static void qualify(PsiMember member, PsiElement renamed, String name) {
        PsiElement replaced;
        if (!(renamed instanceof GrReferenceExpression)) {
            return;
        }
        PsiClass clazz = member.getContainingClass();
        if (clazz == null) {
            return;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)renamed;
        if (refExpr.getQualifierExpression() != null) {
            return;
        }
        if (member.hasModifierProperty("static")) {
            GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getQualifiedName() + "." + name);
            replaced = refExpr.replace(newRefExpr);
        } else {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)renamed, PsiClass.class);
            if (member.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)clazz)) {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText("this." + name);
                replaced = refExpr.replace(newRefExpr);
            } else {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getQualifiedName() + ".this." + name);
                replaced = refExpr.replace(newRefExpr);
            }
        }
        JavaCodeStyleManager.getInstance((Project)replaced.getProject()).shortenClassReferences(replaced);
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/rename/RenameGrFieldProcessor", "canProcessElement"));
        }
        return element instanceof GrField && ((GrField)element).isProperty() || element instanceof GrAccessorMethod;
    }

    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
        ArrayList<1> collisions = new ArrayList<1>();
        for (UsageInfo info : result) {
            PsiType[] typeArguments;
            if (!(info instanceof MoveRenameUsageInfo)) continue;
            PsiElement infoElement = info.getElement();
            PsiElement referencedElement = ((MoveRenameUsageInfo)info).getReferencedElement();
            if (!(infoElement instanceof GrReferenceExpression)) continue;
            final GrReferenceExpression refExpr = (GrReferenceExpression)infoElement;
            if (!(referencedElement instanceof GrField) && !refExpr.advancedResolve().isInvokedOnProperty() || !(refExpr.getParent() instanceof GrCall)) continue;
            PsiType[] argTypes = PsiUtil.getArgumentTypes(refExpr, false);
            MethodResolverProcessor processor = new MethodResolverProcessor(newName, refExpr, false, null, argTypes, typeArguments = refExpr.getTypeArguments());
            final PsiMethod resolved = (PsiMethod)ResolveUtil.resolveExistingElement(refExpr, processor, PsiMethod.class);
            if (resolved == null) continue;
            collisions.add(new UnresolvableCollisionUsageInfo((PsiElement)resolved, refExpr){

                public String getDescription() {
                    return GroovyRefactoringBundle.message("usage.will.be.overriden.by.method", refExpr.getParent().getText(), PsiFormatUtil.formatMethod((PsiMethod)resolved, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)2));
                }
            });
        }
        result.addAll(collisions);
        super.findCollisions(element, newName, allRenames, result);
    }

    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        PsiMethod newSetter;
        PsiMethod setter;
        PsiMethod newGetter;
        super.findExistingNameConflicts(element, newName, conflicts);
        GrField field = (GrField)element;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiMethod getter = GroovyPropertyUtils.findGetterForField(field);
        if (getter instanceof GrAccessorMethod && (newGetter = PropertyUtil.findPropertyGetter((PsiClass)containingClass, (String)newName, (boolean)field.hasModifierProperty("static"), (boolean)true)) != null && !(newGetter instanceof GrAccessorMethod)) {
            conflicts.putValue((Object)newGetter, (Object)GroovyRefactoringBundle.message("implicit.getter.will.by.overriden.by.method", field.getName(), newGetter.getName()));
        }
        if ((setter = GroovyPropertyUtils.findSetterForField(field)) instanceof GrAccessorMethod && (newSetter = PropertyUtil.findPropertySetter((PsiClass)containingClass, (String)newName, (boolean)field.hasModifierProperty("static"), (boolean)true)) != null && !(newSetter instanceof GrAccessorMethod)) {
            conflicts.putValue((Object)newSetter, (Object)GroovyRefactoringBundle.message("implicit.setter.will.by.overriden.by.method", field.getName(), newSetter.getName()));
        }
    }
}

