/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public abstract class GrIntroduceFieldHandlerBase<Settings extends GrIntroduceSettings>
extends GrIntroduceHandlerBase<Settings, PsiClass> {
    @NotNull
    protected PsiClass[] findPossibleScopes(GrExpression expression, GrVariable variable, StringPartInfo partInfo, Editor editor) {
        PsiElement place = GrIntroduceFieldHandlerBase.getCurrentPlace(expression, variable, partInfo);
        PsiClass aClass = PsiUtil.getContextClass(place);
        if (aClass instanceof GroovyScriptClass) {
            PsiClass[] psiClassArray = new PsiClass[]{aClass};
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceFieldHandlerBase", "findPossibleScopes"));
            }
            return psiClassArray;
        }
        ArrayList result = ContainerUtil.newArrayList((Object[])new PsiClass[]{aClass});
        while (aClass != null) {
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
            ContainerUtil.addIfNotNull((Collection)result, (Object)aClass);
        }
        PsiClass[] psiClassArray = result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceFieldHandlerBase", "findPossibleScopes"));
        }
        return psiClassArray;
    }

    protected void showScopeChooser(PsiClass[] scopes, final Pass<PsiClass> callback, Editor editor) {
        PsiElementProcessor<PsiClass> processor = new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceFieldHandlerBase$1", "execute"));
                }
                callback.pass((Object)element);
                return false;
            }
        };
        NavigationUtil.getPsiElementPopup((PsiElement[])scopes, (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)"Choose class to introduce field", (PsiElementProcessor)processor).showInBestPositionFor(editor);
    }

    @Override
    @NotNull
    protected PsiElement[] findOccurrences(@NotNull GrExpression expression, @NotNull PsiElement scope) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceFieldHandlerBase", "findOccurrences"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceFieldHandlerBase", "findOccurrences"));
        }
        if (scope instanceof GroovyScriptClass) {
            scope = scope.getContainingFile();
        }
        PsiElement[] psiElementArray = super.findOccurrences(expression, scope);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceFieldHandlerBase", "findOccurrences"));
        }
        return psiElementArray;
    }
}

