/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public class GroovyInlineMethodUtil {
    public static final String REFACTORING_NAME = GroovyRefactoringBundle.message("inline.method.title", new Object[0]);

    private GroovyInlineMethodUtil() {
    }

    @Nullable
    public static InlineHandler.Settings inlineMethodSettings(GrMethod method, Editor editor, boolean invokedOnReference) {
        Project project = method.getProject();
        if (method.isConstructor()) {
            String message = GroovyRefactoringBundle.message("refactoring.cannot.be.applied.to.constructors", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
        }
        if (invokedOnReference) {
            PsiReference reference;
            PsiReference psiReference = reference = editor != null ? TargetElementUtilBase.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
            if (reference == null) {
                return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            }
            PsiElement element = reference.getElement();
            if (!(element instanceof GrExpression) || !(element.getParent() instanceof GrCallExpression)) {
                String message = GroovyRefactoringBundle.message("refactoring.is.available.only.for.method.calls", REFACTORING_NAME);
                GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
                return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            }
            GrCallExpression call = (GrCallExpression)element.getParent();
            if (PsiTreeUtil.getParentOfType((PsiElement)element, GrParameter.class) != null) {
                String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.in.parameter.initializers", REFACTORING_NAME);
                GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
                return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            }
            GroovyRefactoringUtil.highlightOccurrences(project, editor, new GrExpression[]{call});
            if (GroovyInlineMethodUtil.hasBadReturns(method) && !GroovyInlineMethodUtil.isTailMethodCall(call)) {
                String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", REFACTORING_NAME);
                GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
                return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            }
        } else if (GroovyInlineMethodUtil.hasBadReturns(method)) {
            String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
        }
        if (method.getBlock() == null) {
            String message = method.hasModifierProperty("abstract") ? GroovyRefactoringBundle.message("refactoring.cannot.be.applied.to.abstract.methods", REFACTORING_NAME) : GroovyRefactoringBundle.message("refactoring.cannot.be.applied.no.sources.attached", REFACTORING_NAME);
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
        }
        return GroovyInlineMethodUtil.inlineMethodDialogResult(method, project, invokedOnReference);
    }

    static boolean isTailMethodCall(GrCallExpression call) {
        GrMethod method;
        GrStatement stmt = call;
        PsiElement parent = call.getParent();
        if (parent instanceof GrReturnStatement) {
            stmt = (GrReturnStatement)parent;
            parent = parent.getParent();
        }
        if (parent instanceof GrOpenBlock && parent.getParent() instanceof GrMethod) {
            GrStatement[] statements = ((GrOpenBlock)parent).getStatements();
            return statements.length > 0 && stmt == statements[statements.length - 1];
        }
        if (parent instanceof GrClosableBlock) {
            GrStatement[] statements = ((GrClosableBlock)parent).getStatements();
            return statements.length > 0 && stmt == statements[statements.length - 1];
        }
        if (stmt instanceof GrReturnStatement && (method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)stmt, GrMethod.class)) != null) {
            List<GrStatement> returnStatements = ControlFlowUtils.collectReturns(method.getBlock());
            return returnStatements.contains(stmt) && !GroovyInlineMethodUtil.hasBadReturns(method);
        }
        return false;
    }

    @Nullable
    private static InlineHandler.Settings inlineMethodDialogResult(GrMethod method, Project project, boolean invokedOnReference) {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            final InlineMethodDialog dialog = new InlineMethodDialog(project, method, invokedOnReference, GroovyInlineMethodUtil.checkMethodForRecursion(method));
            dialog.show();
            if (!dialog.isOK()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
                return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            }
            return new InlineHandler.Settings(){

                public boolean isOnlyOneReferenceToInline() {
                    return dialog.isInlineThisOnly();
                }
            };
        }
        return new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return true;
            }
        };
    }

    private static boolean hasBadReturns(GrMethod method) {
        List<GrStatement> returnStatements = ControlFlowUtils.collectReturns(method.getBlock());
        GrOpenBlock block = method.getBlock();
        if (block == null || returnStatements.size() == 0) {
            return false;
        }
        boolean checked = GroovyInlineMethodUtil.checkTailOpenBlock(block, returnStatements);
        return !checked || !returnStatements.isEmpty();
    }

    public static boolean checkTailIfStatement(GrIfStatement ifStatement, Collection<GrStatement> returnStatements) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null) {
            return false;
        }
        boolean tb = false;
        boolean eb = false;
        if (thenBranch instanceof GrReturnStatement) {
            tb = returnStatements.remove(thenBranch);
        } else if (thenBranch instanceof GrBlockStatement) {
            tb = GroovyInlineMethodUtil.checkTailOpenBlock(((GrBlockStatement)thenBranch).getBlock(), returnStatements);
        }
        if (elseBranch instanceof GrReturnStatement) {
            eb = returnStatements.remove(elseBranch);
        } else if (elseBranch instanceof GrBlockStatement) {
            eb = GroovyInlineMethodUtil.checkTailOpenBlock(((GrBlockStatement)elseBranch).getBlock(), returnStatements);
        }
        return tb && eb;
    }

    private static boolean checkTailOpenBlock(GrOpenBlock block, Collection<GrStatement> returnStatements) {
        if (block == null) {
            return false;
        }
        GrStatement[] statements = block.getStatements();
        if (statements.length == 0) {
            return false;
        }
        GrStatement last = statements[statements.length - 1];
        if (returnStatements.contains(last)) {
            returnStatements.remove(last);
            return true;
        }
        if (last instanceof GrIfStatement) {
            return GroovyInlineMethodUtil.checkTailIfStatement((GrIfStatement)last, returnStatements);
        }
        return false;
    }

    private static void showErrorMessage(String message, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
    }

    static boolean isStaticMethod(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineMethodUtil", "isStaticMethod"));
        }
        return method.hasModifierProperty("static");
    }

    static boolean areInSameClass(PsiElement element, GrMethod method) {
        PsiElement parent;
        for (parent = element; parent != null && !(parent instanceof PsiClass) && !(parent instanceof PsiFile); parent = parent.getParent()) {
        }
        if (parent instanceof PsiClass) {
            PsiClass methodClass = method.getContainingClass();
            return parent == methodClass;
        }
        if (parent instanceof GroovyFile) {
            PsiElement mParent = method.getParent();
            return mParent instanceof GroovyFile && mParent == parent;
        }
        return false;
    }

    public static Collection<ReferenceExpressionInfo> collectReferenceInfo(GrMethod method) {
        ArrayList<ReferenceExpressionInfo> list = new ArrayList<ReferenceExpressionInfo>();
        GroovyInlineMethodUtil.collectReferenceInfoImpl(list, method, method);
        return list;
    }

    private static void collectReferenceInfoImpl(Collection<ReferenceExpressionInfo> infos, PsiElement elem, GrMethod method) {
        PsiElement declaration;
        GrReferenceExpression expr;
        PsiReference ref;
        if (elem instanceof GrReferenceExpression && (ref = (expr = (GrReferenceExpression)elem).getReference()) != null && (declaration = ref.resolve()) instanceof GrMember) {
            int offsetInMethod = expr.getTextRange().getStartOffset() - method.getTextRange().getStartOffset();
            GrMember member = (GrMember)declaration;
            infos.add(new ReferenceExpressionInfo(expr, offsetInMethod, member, member.getContainingClass()));
        }
        for (PsiElement element : elem.getChildren()) {
            GroovyInlineMethodUtil.collectReferenceInfoImpl(infos, element, method);
        }
    }

    public static boolean isSimpleReference(GrExpression qualifier) {
        if (!(qualifier instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qual = ((GrReferenceExpression)qualifier).getQualifierExpression();
        return qual == null || GroovyInlineMethodUtil.isSimpleReference(qual);
    }

    static void addQualifiersToInnerReferences(GrMethod method, Collection<ReferenceExpressionInfo> infos, @NotNull GrExpression qualifier) throws IncorrectOperationException {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineMethodUtil", "addQualifiersToInnerReferences"));
        }
        HashSet<GrReferenceExpression> exprs = new HashSet<GrReferenceExpression>();
        for (ReferenceExpressionInfo info : infos) {
            GrReferenceExpression refExpr;
            PsiReference ref = method.findReferenceAt(info.offsetInMethod);
            if (ref == null || !(ref.getElement() instanceof GrReferenceExpression) || (refExpr = (GrReferenceExpression)ref.getElement()).getQualifierExpression() != null) continue;
            exprs.add(refExpr);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(qualifier.getProject());
        for (GrReferenceExpression expr : exprs) {
            GrExpression qual = factory.createExpressionFromText(qualifier.getText());
            expr.setQualifier(qual);
        }
    }

    private static boolean checkMethodForRecursion(GrMethod method) {
        return GroovyInlineMethodUtil.checkCalls(method.getBlock(), method);
    }

    private static boolean checkCalls(PsiElement scope, PsiMethod method) {
        PsiMethod refMethod;
        if (scope instanceof GrMethodCall && method.equals(refMethod = ((GrMethodCall)scope).resolveMethod())) {
            return true;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!GroovyInlineMethodUtil.checkCalls(child, method)) continue;
            return true;
        }
        return false;
    }

    public static void replaceParametersWithArguments(GrCallExpression call, GrMethod method) throws IncorrectOperationException {
        GrParameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return;
        }
        GrArgumentList argumentList = call.getArgumentList();
        if (argumentList == null) {
            GroovyInlineMethodUtil.setDefaultValuesToParameters(method, null, call);
            return;
        }
        Project project = call.getProject();
        GroovyResolveResult resolveResult = call.advancedResolve();
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, resolveResult.getSubstitutor());
        if (signature == null) {
            return;
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] infos = GrClosureSignatureUtil.mapParametersToArguments(signature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), call, true, false);
        if (infos == null) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            GrParameter parameter = parameters[i];
            GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo = infos[i];
            GrExpression arg = GroovyInlineMethodUtil.inferArg(signature, parameters, parameter, argInfo, project);
            if (arg == null) continue;
            GroovyInlineMethodUtil.replaceAllOccurrencesWithExpression(method, call, arg, parameter);
        }
    }

    @Nullable
    private static GrExpression inferArg(GrClosureSignature signature, GrParameter[] parameters, GrParameter parameter, GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo, Project project) {
        if (argInfo == null) {
            return null;
        }
        List arguments = argInfo.args;
        if (argInfo.isMultiArg) {
            PsiType type = parameter.getDeclaredType();
            return GroovyRefactoringUtil.generateArgFromMultiArg(signature.getSubstitutor(), arguments, type, project);
        }
        if (arguments.size() == 1) {
            GrExpression expr;
            PsiElement arg = (PsiElement)arguments.iterator().next();
            if (GroovyInlineMethodUtil.isVararg(parameter, parameters) && arg instanceof GrSafeCastExpression && (expr = ((GrSafeCastExpression)arg).getOperand()) instanceof GrListOrMap && !((GrListOrMap)expr).isMap()) {
                return (GrListOrMap)expr;
            }
            return (GrExpression)arg;
        }
        return parameter.getInitializerGroovy();
    }

    private static boolean isVararg(GrParameter p, GrParameter[] parameters) {
        return parameters[parameters.length - 1] == p && p.getType() instanceof PsiArrayType;
    }

    private static void setDefaultValuesToParameters(GrMethod method, @Nullable Collection<String> nameFilter, GrCallExpression call) throws IncorrectOperationException {
        GrParameter[] parameters;
        if (nameFilter == null) {
            nameFilter = new ArrayList<String>();
            for (GrParameter parameter : method.getParameters()) {
                nameFilter.add(parameter.getName());
            }
        }
        for (GrParameter parameter : parameters = method.getParameters()) {
            GrExpression initializer = parameter.getInitializerGroovy();
            if (!nameFilter.contains(parameter.getName()) || initializer == null) continue;
            GroovyInlineMethodUtil.replaceAllOccurrencesWithExpression(method, call, initializer, parameter);
        }
    }

    private static void replaceAllOccurrencesWithExpression(GrMethod method, GrCallExpression call, GrExpression oldExpression, GrParameter parameter) {
        Collection refs = ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)method), (boolean)false).findAll();
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(call.getProject());
        GrExpression expression = elementFactory.createExpressionFromText(oldExpression.getText());
        if (GroovyRefactoringUtil.hasSideEffect(expression) && refs.size() > 1 || !GroovyInlineMethodUtil.hasUnresolvableWriteAccess(refs, oldExpression)) {
            String oldName = parameter.getName();
            String newName = InlineMethodConflictSolver.suggestNewName(oldName, method, call, new String[0]);
            expression = elementFactory.createExpressionFromText(newName);
            GrOpenBlock body = method.getBlock();
            GrStatement[] statements = body.getStatements();
            GrStatement anchor = null;
            if (statements.length > 0) {
                anchor = statements[0];
            }
            body.addStatementBefore(elementFactory.createStatementFromText(GroovyInlineMethodUtil.createVariableDefinitionText(parameter, oldExpression, newName)), anchor);
        }
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (!(element instanceof GrReferenceExpression)) continue;
            ((GrReferenceExpression)element).replaceWithExpression(expression, true);
        }
    }

    private static String createVariableDefinitionText(GrParameter parameter, GrExpression expression, String varName) {
        GrTypeElement typeElement;
        StringBuilder buffer = new StringBuilder();
        GrModifierList modifierList = parameter.getModifierList();
        buffer.append(modifierList.getText().trim());
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        if ((typeElement = parameter.getTypeElementGroovy()) != null) {
            buffer.append(typeElement.getText()).append(' ');
        }
        if (buffer.length() == 0) {
            buffer.append("def ");
        }
        buffer.append(varName).append(" = ").append(expression.getText());
        return buffer.toString();
    }

    private static boolean containsWriteAccess(Collection<PsiReference> refs) {
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            PsiElement parent = element.getParent();
            if (parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getLValue() == element) {
                return true;
            }
            if (!(parent instanceof GrUnaryExpression)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnresolvableWriteAccess(Collection<PsiReference> refs, GrExpression expression) {
        if (GroovyInlineMethodUtil.containsWriteAccess(refs)) {
            boolean isFinal;
            PsiElement resolved;
            if (expression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expression).resolve()) instanceof GrVariable && !(resolved instanceof PsiField) && !(isFinal = ((GrVariable)resolved).hasModifierProperty("final"))) {
                PsiReference lastRef = Collections.max(ReferencesSearch.search((PsiElement)resolved).findAll(), new Comparator<PsiReference>(){

                    @Override
                    public int compare(PsiReference o1, PsiReference o2) {
                        return o1.getElement().getTextRange().getStartOffset() - o2.getElement().getTextRange().getStartOffset();
                    }
                });
                return lastRef.getElement() == expression;
            }
            return false;
        }
        return true;
    }

    static class InlineMethodDialog
    extends InlineOptionsDialog {
        public static final String REFACTORING_NAME = GroovyRefactoringBundle.message("inline.method.title", new Object[0]);
        private final boolean myAllowInlineThisOnly;
        private final PsiMethod myMethod;

        public InlineMethodDialog(Project project, PsiMethod method, boolean invokedOnReference, boolean allowInlineThisOnly) {
            super(project, true, (PsiElement)method);
            this.myMethod = method;
            this.myAllowInlineThisOnly = allowInlineThisOnly;
            this.myInvokedOnReference = invokedOnReference;
            this.setTitle(REFACTORING_NAME);
            this.init();
        }

        protected String getBorderTitle() {
            return GroovyRefactoringBundle.message("inline.method.border.title", new Object[0]);
        }

        protected String getNameLabelText() {
            return GroovyRefactoringBundle.message("inline.method.label", GroovyRefactoringUtil.getMethodSignature(this.myMethod));
        }

        protected String getInlineAllText() {
            return this.myMethod.isWritable() ? GroovyRefactoringBundle.message("all.invocations.and.remove.the.method", new Object[0]) : GroovyRefactoringBundle.message("all.invocations.in.project", new Object[0]);
        }

        protected String getInlineThisText() {
            return GroovyRefactoringBundle.message("this.invocation.only.and.keep.the.method", new Object[0]);
        }

        protected boolean isInlineThis() {
            return false;
        }

        protected void doAction() {
            if (this.getOKAction().isEnabled()) {
                this.close(0);
            }
        }

        protected void doHelpAction() {
            HelpManager.getInstance().invokeHelp("refactoring.inlineMethod");
        }

        protected boolean canInlineThisOnly() {
            return this.myAllowInlineThisOnly;
        }
    }

    static class ReferenceExpressionInfo {
        public final PsiMember declaration;
        public final GrReferenceExpression expression;
        public final int offsetInMethod;
        public final PsiClass containingClass;

        @Nullable
        public String getPresentation() {
            return this.declaration.getName();
        }

        public boolean isStatic() {
            return this.declaration.hasModifierProperty("static");
        }

        public ReferenceExpressionInfo(GrReferenceExpression expression, int offsetInMethod, PsiMember declaration, PsiClass containingClass) {
            this.expression = expression;
            this.offsetInMethod = offsetInMethod;
            this.declaration = declaration;
            this.containingClass = containingClass;
        }
    }
}

