/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineLocalProcessor;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineLocalVarSettings;

public class GroovyInlineLocalHandler
extends InlineActionHandler {
    private static Logger LOG = Logger.getInstance(GroovyInlineLocalHandler.class);
    public static final String INLINE_VARIABLE = RefactoringBundle.message((String)"inline.variable.title");

    public boolean isEnabledForLanguage(Language l) {
        return GroovyFileType.GROOVY_LANGUAGE == l;
    }

    public boolean canInlineElement(PsiElement element) {
        return GroovyRefactoringUtil.isLocalVariable(element);
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        GroovyInlineLocalHandler.invoke(project, editor, (GrVariable)element);
    }

    public static void invoke(Project project, Editor editor, GrVariable local) {
        PsiReference invocationReference = editor != null ? TargetElementUtilBase.findReference((Editor)editor) : null;
        InlineLocalVarSettings localVarSettings = GroovyInlineLocalHandler.createSettings(local, editor, invocationReference != null);
        if (localVarSettings == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        GroovyInlineLocalProcessor processor = new GroovyInlineLocalProcessor(project, localVarSettings, local);
        processor.setPrepareSuccessfulSwingThreadCallback(new Runnable(){

            @Override
            public void run() {
            }
        });
        processor.run();
    }

    @Nullable
    private static InlineLocalVarSettings createSettings(final GrVariable variable, Editor editor, boolean invokedOnReference) {
        String localName = variable.getName();
        Project project = variable.getProject();
        GrExpression initializer = null;
        Object writeInstr = null;
        Object[] flow = null;
        if (invokedOnReference) {
            LOG.assertTrue(editor != null, (Object)"null editor but invokedOnReference==true");
            PsiReference ref = TargetElementUtilBase.findReference((Editor)editor);
            LOG.assertTrue(ref != null);
            PsiElement cur = ref.getElement();
            if (cur instanceof GrReferenceExpression) {
                GrControlFlowOwner controlFlowOwner;
                while ((controlFlowOwner = ControlFlowUtils.findControlFlowOwner(cur)) != null) {
                    flow = controlFlowOwner.getControlFlow();
                    ArrayList<BitSet> writes = ControlFlowUtils.inferWriteAccessMap((Instruction[])flow, variable);
                    PsiElement finalCur = cur;
                    Instruction instruction = ControlFlowUtils.findInstruction(finalCur, (Instruction[])flow);
                    LOG.assertTrue(instruction != null);
                    BitSet prev = writes.get(instruction.num());
                    if (prev.cardinality() == 1) {
                        writeInstr = flow[prev.nextSetBit(0)];
                        PsiElement element = writeInstr.getElement();
                        if (element instanceof GrVariable) {
                            initializer = ((GrVariable)element).getInitializerGroovy();
                        } else if (element instanceof GrReferenceExpression) {
                            initializer = TypeInferenceHelper.getInitializerFor((GrReferenceExpression)element);
                        }
                    }
                    PsiElement old_cur = cur;
                    if (controlFlowOwner instanceof GrClosableBlock) {
                        cur = controlFlowOwner;
                    } else {
                        PsiElement parent = controlFlowOwner.getParent();
                        if (parent instanceof GrMember) {
                            cur = ((GrMember)parent).getContainingClass();
                        }
                    }
                    if (cur != old_cur && initializer == null) continue;
                    break;
                }
            }
        } else {
            flow = ControlFlowUtils.findControlFlowOwner(variable).getControlFlow();
            initializer = variable.getInitializerGroovy();
            writeInstr = (Instruction)ContainerUtil.find((Object[])flow, (Condition)new Condition<Instruction>(){

                public boolean value(Instruction instruction) {
                    return instruction.getElement() == variable;
                }
            });
        }
        if (initializer == null || writeInstr == null) {
            String message = GroovyRefactoringBundle.message("cannot.find.a.single.definition.to.inline.local.var", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)variable.getProject(), (Editor)editor, (String)message, (String)INLINE_VARIABLE, (String)"refactoring.inlineVariable");
            return null;
        }
        int writeInstructionNumber = writeInstr.num();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new InlineLocalVarSettings(initializer, writeInstructionNumber, (Instruction[])flow);
        }
        String question = GroovyRefactoringBundle.message("inline.local.variable.prompt.0.1", localName);
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(INLINE_VARIABLE, question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
        dialog.show();
        if (dialog.isOK()) {
            return new InlineLocalVarSettings(initializer, writeInstructionNumber, (Instruction[])flow);
        }
        return null;
    }
}

