/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.closure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.ChangedMethodCallInfo;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureProcessorBase;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.OtherLanguageUsageInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.FieldConflictsResolver;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrExpressionWrapper;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.util.AnySupers;

public class ExtractClosureFromMethodProcessor
extends ExtractClosureProcessorBase {
    private final GrMethod myMethod;
    private final GrStatementOwner myDeclarationOwner;

    public ExtractClosureFromMethodProcessor(@NotNull GrIntroduceParameterSettings helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromMethodProcessor", "<init>"));
        }
        super(helper);
        GrStatement[] statements = helper.getStatements();
        this.myDeclarationOwner = statements.length > 0 ? GroovyRefactoringUtil.getDeclarationOwner(statements[0]) : null;
        this.myMethod = (GrMethod)this.myHelper.getToReplaceIn();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        GrStatement[] statements;
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        for (GrStatement grStatement : statements = this.myHelper.getStatements()) {
            GroovyIntroduceParameterUtil.detectAccessibilityConflicts(grStatement, usagesIn, (MultiMap<PsiElement, String>)conflicts, false, this.myProject);
        }
        for (GrStatement grStatement : usagesIn) {
            if (!(grStatement instanceof OtherLanguageUsageInfo)) continue;
            String string = CommonRefactoringUtil.htmlEmphasize((String)grStatement.getElement().getLanguage().getDisplayName());
            conflicts.putValue((Object)grStatement.getElement(), (Object)GroovyRefactoringBundle.message("cannot.process.usage.in.language.{0}", string));
        }
        if (!this.myMethod.hasModifierProperty("private")) {
            void var8_13;
            AnySupers anySupers = new AnySupers();
            GrStatement[] arr$ = statements;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_13 < len$) {
                GrStatement grStatement = arr$[var8_13];
                grStatement.accept(anySupers);
                ++var8_13;
            }
            if (anySupers.containsSupers()) {
                void var8_15;
                arr$ = usagesIn;
                len$ = arr$.length;
                boolean bl2 = false;
                while (var8_15 < len$) {
                    GrStatement grStatement = arr$[var8_15];
                    if (!(grStatement.getElement() instanceof PsiMethod || grStatement instanceof InternalUsageInfo || PsiTreeUtil.isAncestor((PsiElement)this.myMethod.getContainingClass(), (PsiElement)grStatement.getElement(), (boolean)false))) {
                        conflicts.putValue((Object)statements[0], (Object)RefactoringBundle.message((String)"parameter.initializer.contains.0.but.not.all.calls.to.method.are.in.its.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)"super")}));
                        break;
                    }
                    ++var8_15;
                }
            }
        }
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = this.prepareConflictsDialog(conflicts, usagesIn);
            conflictsDialog.show();
            if (!conflictsDialog.isOK()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PsiMethod toSearchFor = (PsiMethod)this.myHelper.getToSearchFor();
        for (PsiReference ref1 : MethodReferencesSearch.search((PsiMethod)toSearchFor, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)true)) {
            PsiElement ref = ref1.getElement();
            if (ref.getLanguage() != GroovyFileType.GROOVY_LANGUAGE) {
                result.add(new OtherLanguageUsageInfo(ref1));
                continue;
            }
            if (ref instanceof PsiMethod && ((PsiMethod)ref).isConstructor()) {
                DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)ref, ((PsiMethod)ref).getContainingClass(), toSearchFor);
                result.add((UsageInfo)implicitUsageInfo);
                continue;
            }
            if (ref instanceof PsiClass) {
                result.add((UsageInfo)new NoConstructorClassUsageInfo((PsiClass)ref));
                continue;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)ref, (boolean)false)) {
                result.add((UsageInfo)new ExternalUsageInfo(ref));
                continue;
            }
            result.add((UsageInfo)new ChangedMethodCallInfo(ref));
        }
        Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)toSearchFor, (boolean)true).findAll();
        for (PsiMethod overridingMethod : overridingMethods) {
            result.add(new UsageInfo((PsiElement)overridingMethod));
        }
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromMethodProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo[] usages) {
        boolean methodsToProcessAreDifferent;
        IntroduceParameterDataAdapter data = new IntroduceParameterDataAdapter();
        IntroduceParameterUtil.processUsages((UsageInfo[])usages, (IntroduceParameterData)data);
        PsiMethod toSearchFor = (PsiMethod)this.myHelper.getToSearchFor();
        boolean bl = methodsToProcessAreDifferent = this.myMethod != toSearchFor;
        if (this.myHelper.generateDelegate()) {
            GrOpenBlock block;
            GrMethod method;
            PsiClass containingClass;
            GroovyIntroduceParameterUtil.generateDelegate(this.myMethod, data.getParameterInitializer(), this.myProject);
            if (methodsToProcessAreDifferent && (containingClass = (method = GroovyIntroduceParameterUtil.generateDelegate(toSearchFor, data.getParameterInitializer(), this.myProject)).getContainingClass()) != null && containingClass.isInterface() && (block = method.getBlock()) != null) {
                block.delete();
            }
        }
        FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(this.myHelper.getName(), this.myMethod.getBlock());
        IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts((UsageInfo)new UsageInfo((PsiElement)this.myMethod), (UsageInfo[])usages, (IntroduceParameterData)data);
        if (methodsToProcessAreDifferent) {
            IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts((UsageInfo)new UsageInfo((PsiElement)toSearchFor), (UsageInfo[])usages, (IntroduceParameterData)data);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ChangedMethodCallInfo)) continue;
            PsiElement element = usage.getElement();
            GroovyIntroduceParameterUtil.processChangedMethodCall(element, this.myHelper, this.myProject);
        }
        GrStatement newStatement = ExtractUtil.replaceStatement(this.myDeclarationOwner, this.myHelper);
        Editor editor = PsiUtilBase.findEditor((PsiElement)newStatement);
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(newStatement.getTextRange().getEndOffset());
        }
        fieldConflictsResolver.fix();
    }

    private class IntroduceParameterDataAdapter
    implements IntroduceParameterData {
        private final GrClosableBlock myClosure;
        private final GrExpressionWrapper myWrapper;

        private IntroduceParameterDataAdapter() {
            this.myClosure = ExtractClosureProcessorBase.generateClosure(ExtractClosureFromMethodProcessor.this.myHelper);
            this.myWrapper = new GrExpressionWrapper(this.myClosure);
        }

        @NotNull
        public Project getProject() {
            Project project = ExtractClosureFromMethodProcessor.this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromMethodProcessor$IntroduceParameterDataAdapter", "getProject"));
            }
            return project;
        }

        public PsiMethod getMethodToReplaceIn() {
            return ExtractClosureFromMethodProcessor.this.myMethod;
        }

        @NotNull
        public PsiMethod getMethodToSearchFor() {
            PsiMethod psiMethod = (PsiMethod)ExtractClosureFromMethodProcessor.this.myHelper.getToSearchFor();
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromMethodProcessor$IntroduceParameterDataAdapter", "getMethodToSearchFor"));
            }
            return psiMethod;
        }

        public IntroduceParameterData.ExpressionWrapper getParameterInitializer() {
            return this.myWrapper;
        }

        @NotNull
        public String getParameterName() {
            String string = ExtractClosureFromMethodProcessor.this.myHelper.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromMethodProcessor$IntroduceParameterDataAdapter", "getParameterName"));
            }
            return string;
        }

        public int getReplaceFieldsWithGetters() {
            return 0;
        }

        public boolean isDeclareFinal() {
            return ExtractClosureFromMethodProcessor.this.myHelper.declareFinal();
        }

        public boolean isGenerateDelegate() {
            return false;
        }

        @NotNull
        public PsiType getForcedType() {
            PsiType type = ExtractClosureFromMethodProcessor.this.myHelper.getSelectedType();
            Object object = type != null ? type : PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)ExtractClosureFromMethodProcessor.this.myProject), (GlobalSearchScope)GlobalSearchScope.allScope((Project)ExtractClosureFromMethodProcessor.this.myProject));
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromMethodProcessor$IntroduceParameterDataAdapter", "getForcedType"));
            }
            return object;
        }

        @NotNull
        public TIntArrayList getParametersToRemove() {
            TIntArrayList tIntArrayList = ExtractClosureFromMethodProcessor.this.myHelper.parametersToRemove();
            if (tIntArrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromMethodProcessor$IntroduceParameterDataAdapter", "getParametersToRemove"));
            }
            return tIntArrayList;
        }
    }
}

