/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.LocalVarAnalyzer;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeProvider;

class ExpressionContext
implements Cloneable {
    List<String> myStatements = new ArrayList<String>();
    Set<String> myUsedVarNames;
    LocalVarAnalyzer.Result analyzedVars = LocalVarAnalyzer.initialResult();
    TypeProvider typeProvider;
    Project project;
    private Map<String, Boolean> myProps = new HashMap();
    private static final String myShouldInsertCurlyBrackets = "shouldInsertCurly";
    private static final String myInAnonymousContext = "inAnonymousContext";
    private Ref<String> myRefSetterName = new Ref(null);
    private Map<PsiMethod, String> setters;
    private Set<PsiClass> myClasses;

    private ExpressionContext(Project project, Set<String> usedVarNames, Map<PsiMethod, String> setters, Set<PsiClass> myClasses) {
        this.project = project;
        this.myUsedVarNames = usedVarNames;
        this.setters = setters;
        this.myClasses = myClasses;
    }

    ExpressionContext(Project project, GroovyFile[] filesToConvert) {
        this(project, (Set<String>)new HashSet(), (Map<PsiMethod, String>)new HashMap(), (Set<PsiClass>)new HashSet());
        this.typeProvider = new TypeProvider();
        for (GroovyFile groovyFile : filesToConvert) {
            this.myClasses.addAll(Arrays.asList(groovyFile.getClasses()));
        }
    }

    public Object clone() {
        return this.copy();
    }

    ExpressionContext copy() {
        ExpressionContext expressionContext = new ExpressionContext(this.project, this.myUsedVarNames, this.setters, this.myClasses);
        expressionContext.myProps.putAll(this.myProps);
        expressionContext.analyzedVars = this.analyzedVars;
        expressionContext.typeProvider = this.typeProvider;
        expressionContext.myRefSetterName = this.myRefSetterName;
        return expressionContext;
    }

    ExpressionContext extend() {
        HashSet usedVarNames = new HashSet();
        usedVarNames.addAll(this.myUsedVarNames);
        ExpressionContext expressionContext = new ExpressionContext(this.project, (Set<String>)usedVarNames, this.setters, this.myClasses);
        expressionContext.myProps.putAll(this.myProps);
        expressionContext.analyzedVars = this.analyzedVars;
        expressionContext.typeProvider = this.typeProvider;
        expressionContext.myRefSetterName = this.myRefSetterName;
        return expressionContext;
    }

    public void setInsertCurlyBrackets() {
        this.myProps.put(myShouldInsertCurlyBrackets, true);
    }

    private boolean getProp(String name) {
        Boolean aBoolean = this.myProps.get(name);
        return aBoolean != null && aBoolean != false;
    }

    public boolean shouldInsertCurlyBrackets() {
        return this.getProp(myShouldInsertCurlyBrackets);
    }

    public boolean isInAnonymousContext() {
        return this.getProp(myInAnonymousContext);
    }

    public void setInAnonymousContext(boolean inAnonymousContext) {
        this.myProps.put(myInAnonymousContext, inAnonymousContext);
    }

    public void searchForLocalVarsToWrap(GroovyPsiElement root) {
        this.analyzedVars = LocalVarAnalyzer.searchForVarsToWrap(root, this.analyzedVars, this);
    }

    public String getRefSetterName() {
        return (String)this.myRefSetterName.get();
    }

    public String getRefSetterName(GroovyPsiElement context) {
        if (this.myRefSetterName.isNull()) {
            this.myRefSetterName.set((Object)GenerationUtil.suggestMethodName(context, "setGroovyRef", this));
        }
        return (String)this.myRefSetterName.get();
    }

    public String getSetterName(PsiMethod setter, GroovyPsiElement place) {
        String name = this.setters.get(setter);
        if (name != null) {
            return name;
        }
        name = GenerationUtil.suggestMethodName(place, setter.getName(), this);
        this.setters.put(setter, name);
        return name;
    }

    public Map<PsiMethod, String> getSetters() {
        return Collections.unmodifiableMap(this.setters);
    }

    public boolean isClassConverted(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        return this.myClasses.contains(aClass);
    }
}

