/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.noReturnMethod.MissingReturnInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGeneratorImpl;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class ClosureGenerator {
    private static final Logger LOG = Logger.getInstance(ClosureGenerator.class);
    public static final String[] MODIFIERS = new String[]{"public"};
    private final StringBuilder builder;
    private final ExpressionContext context;

    public ClosureGenerator(@NotNull StringBuilder builder, @NotNull ExpressionContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "<init>"));
        }
        this.builder = builder;
        this.context = context;
    }

    public void generate(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "generate"));
        }
        this.builder.append("new ");
        TypeWriter.writeTypeForNew(this.builder, closure.getType(), closure);
        this.builder.append('(');
        CharSequence owner = this.getOwner(closure);
        this.builder.append(owner);
        this.builder.append(", ");
        this.builder.append(owner);
        this.builder.append(") {\n");
        this.generateClosureMainMethod(closure);
        ClassItemGeneratorImpl generator = new ClassItemGeneratorImpl(this.context);
        GrMethod method = this.generateClosureMethod(closure);
        GrReflectedMethod[] reflectedMethods = method.getReflectedMethods();
        if (reflectedMethods.length > 0) {
            for (GrReflectedMethod reflectedMethod : reflectedMethods) {
                if (reflectedMethod.getSkippedParameters().length <= 0) continue;
                generator.writeMethod(this.builder, reflectedMethod);
                this.builder.append('\n');
            }
        }
        this.builder.append('}');
    }

    private void generateClosureMainMethod(@NotNull GrClosableBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "generateClosureMainMethod"));
        }
        this.builder.append("public ");
        PsiType returnType = this.context.typeProvider.getReturnType(block);
        TypeWriter.writeType(this.builder, returnType, block);
        this.builder.append(" doCall");
        PsiParameter[] parameters = block.getAllParameters();
        GenerationUtil.writeParameterList(this.builder, parameters, new GeneratorClassNameProvider(), this.context);
        Set<GrStatement> myExitPoints = returnType != PsiType.VOID ? ControlFlowUtils.collectReturns(block) : Collections.emptySet();
        boolean shouldInsertReturnNull = !(returnType instanceof PsiPrimitiveType) && MissingReturnInspection.methodMissesSomeReturns(block, MissingReturnInspection.ReturnStatus.shouldNotReturnValue);
        new CodeBlockGenerator(this.builder, this.context.extend(), myExitPoints).generateCodeBlock(block, shouldInsertReturnNull);
        this.builder.append('\n');
    }

    @NotNull
    private GrMethod generateClosureMethod(@NotNull GrClosableBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "generateClosureMethod"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.context.project);
        GrMethod method = factory.createMethodFromText("def doCall(){}", block);
        method.setReturnType(this.context.typeProvider.getReturnType(block));
        if (block.hasParametersSection()) {
            method.getParameterList().replace(block.getParameterList());
        } else {
            GrParameter[] allParameters = block.getAllParameters();
            LOG.assertTrue(allParameters.length == 1);
            GrParameter itParameter = allParameters[0];
            GrParameter parameter = factory.createParameter("it", itParameter.getType().getCanonicalText(), "null", block, new String[0]);
            method.getParameterList().add(parameter);
        }
        ((GroovyFileImpl)method.getContainingFile()).setContextNullable(null);
        GrMethod grMethod = method;
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "generateClosureMethod"));
        }
        return grMethod;
    }

    @NonNls
    @NotNull
    private CharSequence getOwner(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "getOwner"));
        }
        GroovyPsiElement context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)closure, (Class[])new Class[]{GrMember.class, GroovyFile.class});
        LOG.assertTrue(context != null);
        Object contextClass = context instanceof GroovyFile ? ((GroovyFile)context).getScriptClass() : (context instanceof PsiClass ? (PsiClass)context : (context instanceof GrMember ? (((GrMember)context).hasModifierProperty("static") ? null : ((GrMember)context).getContainingClass()) : null));
        if (contextClass == null) {
            if ("null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "getOwner"));
            }
            return "null";
        }
        PsiElement implicitClass = GenerationUtil.getWrappingImplicitClass(closure);
        if (implicitClass == null) {
            if ("this" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "getOwner"));
            }
            return "this";
        }
        StringBuilder buffer = new StringBuilder();
        GenerationUtil.writeThisReference(contextClass, buffer, this.context);
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClosureGenerator", "getOwner"));
        }
        return stringBuilder;
    }
}

