/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ModifierListGenerator;

public class ClassGenerator {
    private final ClassNameProvider classNameProvider;
    private final ClassItemGenerator classItemGenerator;

    public ClassGenerator(ClassNameProvider classNameProvider, ClassItemGenerator classItemGenerator) {
        this.classNameProvider = classNameProvider;
        this.classItemGenerator = classItemGenerator;
    }

    private void writePackageStatement(StringBuilder text, GrPackageDefinition packageDefinition) {
        if (packageDefinition != null) {
            ModifierListGenerator.writeModifiers(text, packageDefinition.getAnnotationList(), ModifierListGenerator.JAVA_MODIFIERS, this.classItemGenerator.generateAnnotations());
            text.append("package ");
            text.append(packageDefinition.getPackageName());
            text.append(';');
            text.append('\n');
            text.append('\n');
        }
    }

    public void writeTypeDefinition(StringBuilder text, @NotNull PsiClass typeDefinition, boolean toplevel, boolean insertPackageSmst) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ClassGenerator", "writeTypeDefinition"));
        }
        boolean isScript = typeDefinition instanceof GroovyScriptClass;
        GroovyFile containingFile = (GroovyFile)typeDefinition.getContainingFile();
        if (insertPackageSmst) {
            this.writePackageStatement(text, containingFile.getPackageDefinition());
        }
        GenerationUtil.writeDocComment(text, (PsiMember)typeDefinition, true);
        boolean isEnum = typeDefinition.isEnum();
        boolean isAnnotationType = typeDefinition.isAnnotationType();
        boolean isInterface = typeDefinition.isInterface();
        ModifierListGenerator.writeClassModifiers(text, typeDefinition.getModifierList(), typeDefinition.isInterface(), typeDefinition.isEnum(), toplevel, this.classItemGenerator.generateAnnotations());
        if (isAnnotationType) {
            text.append('@');
        }
        if (isInterface) {
            text.append("interface");
        } else if (isEnum) {
            text.append("enum");
        } else {
            text.append("class");
        }
        text.append(' ').append(typeDefinition.getName());
        GenerationUtil.writeTypeParameters(text, (PsiTypeParameterListOwner)typeDefinition, this.classNameProvider);
        text.append(' ');
        if (isScript) {
            text.append("extends ").append("groovy.lang.Script").append(' ');
        } else if (!isEnum && !isAnnotationType) {
            this.classItemGenerator.writeExtendsList(text, typeDefinition);
            this.classItemGenerator.writeImplementsList(text, typeDefinition);
        }
        text.append("{\n");
        this.writeMembers(text, typeDefinition);
        text.append('}');
    }

    /*
     * WARNING - void declaration
     */
    public void writeMembers(StringBuilder text, PsiClass typeDefinition) {
        if (typeDefinition instanceof GrEnumTypeDefinition) {
            void var6_8;
            GrEnumConstant[] enumConstants;
            GrEnumConstant[] arr$ = enumConstants = ((GrEnumTypeDefinition)typeDefinition).getEnumConstants();
            int len$ = arr$.length;
            boolean bl = false;
            while (var6_8 < len$) {
                GrEnumConstant constant = arr$[var6_8];
                this.classItemGenerator.writeEnumConstant(text, constant);
                text.append(',');
                ++var6_8;
            }
            if (enumConstants.length > 0) {
                text.delete(text.length() - 1, text.length());
            }
            text.append(";\n");
        }
        this.writeAllMethods(text, this.classItemGenerator.collectMethods(typeDefinition), typeDefinition);
        if (typeDefinition instanceof GrTypeDefinition) {
            for (GrMembersDeclaration grMembersDeclaration : ((GrTypeDefinition)typeDefinition).getMemberDeclarations()) {
                if (!(grMembersDeclaration instanceof GrVariableDeclaration)) continue;
                this.classItemGenerator.writeVariableDeclarations(text, (GrVariableDeclaration)grMembersDeclaration);
            }
            for (GrMembersDeclaration grMembersDeclaration : typeDefinition.getInnerClasses()) {
                this.writeTypeDefinition(text, (PsiClass)grMembersDeclaration, false, false);
                text.append('\n');
            }
        }
        this.classItemGenerator.writePostponed(text, typeDefinition);
    }

    private void writeAllMethods(StringBuilder text, Collection<PsiMethod> methods, PsiClass aClass) {
        for (PsiMethod method : methods) {
            if (!ClassGenerator.shouldBeGenerated(method)) continue;
            if (method.isConstructor()) {
                this.classItemGenerator.writeConstructor(text, method, aClass.isEnum());
                continue;
            }
            this.classItemGenerator.writeMethod(text, method);
            text.append('\n');
        }
    }

    private static boolean shouldBeGenerated(PsiMethod method) {
        for (PsiMethod psiMethod : method.findSuperMethods()) {
            if (psiMethod.hasModifierProperty("abstract")) continue;
            PsiType type = method.getReturnType();
            PsiType superType = psiMethod.getReturnType();
            if (type == null || superType == null || superType.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }
}

