/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public class GroovyNamesUtil {
    private static final Pattern PATTERN = Pattern.compile("[A-Za-z][a-z0-9]*");

    private GroovyNamesUtil() {
    }

    public static boolean isIdentifier(@Nullable String text) {
        if (text == null) {
            return false;
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        if (lexer.getTokenType() != GroovyTokenTypes.mIDENT) {
            return false;
        }
        lexer.advance();
        return lexer.getTokenType() == null;
    }

    public static boolean isValidReference(@Nullable String text, boolean afterDot, Project project) {
        if (text == null) {
            return false;
        }
        try {
            GroovyPsiElementFactory.getInstance(project).createReferenceExpressionFromText(afterDot ? "foo." + text : text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ArrayList<String> camelizeString(String str) {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Matcher matcher = PATTERN.matcher(str);
        while (matcher.find()) {
            res.add(matcher.group().toLowerCase());
            sb.append(matcher.group());
        }
        if (!GroovyNamesUtil.isIdentifier(sb.toString())) {
            res.clear();
        }
        return res;
    }

    static String deleteNonLetterFromString(String tempString) {
        return tempString.replaceAll("[^a-zA-Z]", "");
    }

    static String fromLowerLetter(String str) {
        if (str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        char c = Character.toLowerCase(str.charAt(0));
        if (c == str.charAt(0)) {
            return str;
        }
        return c + str.substring(1);
    }

    public static String camelToSnake(String string) {
        return StringUtil.join(GroovyNamesUtil.camelizeString(string), (Function)new Function<String, String>(){

            public String fun(String s) {
                return StringUtil.decapitalize((String)s);
            }
        }, (String)"-");
    }

    public static boolean isKeyword(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/GroovyNamesUtil", "isKeyword"));
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(name);
        IElementType type = lexer.getTokenType();
        return TokenSets.KEYWORDS.contains(type);
    }
}

