/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.util;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;

public class MvcTargetDialogCompletionUtils {
    private static final Key<CachedValue<Set<String>>> ALL_TARGET_KEY = Key.create((String)"MvcTargetDialogCompletionUtils");
    private static final String[] SYSTEM_PROPERTIES = new String[]{"grails.home", "ivy.default.ivy.user.dir", "ivy.default.conf.dir", "ivy.local.default.root", "ivy.local.default.ivy.pattern", "ivy.local.default.artifact.pattern", "ivy.shared.default.root", "ivy.shared.default.ivy.pattern", "ivy.shared.default.artifact.pattern", "ivy.ivyrep.default.ivy.root", "ivy.ivyrep.default.ivy.pattern", "ivy.ivyrep.default.artifact.root", "ivy.ivyrep.default.artifact.pattern", "grails.servlet.version", "base.dir", "grails.work.dir", "grails.project.work.dir", "grails.project.war.exploded.dir", "grails.project.plugins.dir", "grails.global.plugins.dir", "grails.project.resource.dir", "grails.project.source.dir", "grails.project.web.xml", "grails.project.class.dir", "grails.project.plugin.class.dir", "grails.project.plugin.build.class.dir", "grails.project.plugin.provided.class.dir", "grails.project.test.class.dir", "grails.project.test.reports.dir", "grails.project.docs.output.dir", "grails.project.test.source.dir", "grails.project.target.dir", "grails.project.war.file", "grails.project.war.file", "grails.project.war.osgi.headers", "grails.build.listeners", "grails.project.compile.verbose", "grails.testing.functional.baseUrl", "grails.compile.artefacts.closures.convert"};
    private static List<LookupElement> SYSTEM_PROPERTIES_VARIANTS;

    private MvcTargetDialogCompletionUtils() {
    }

    public static List<LookupElement> getSystemPropertiesVariants() {
        if (SYSTEM_PROPERTIES_VARIANTS == null) {
            LookupElement[] res = new LookupElement[SYSTEM_PROPERTIES.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)("-D" + SYSTEM_PROPERTIES[i])), (TailType)MyTailTypeEQ.INSTANCE);
            }
            SYSTEM_PROPERTIES_VARIANTS = Arrays.asList(res);
        }
        return SYSTEM_PROPERTIES_VARIANTS;
    }

    public static Collection<LookupElement> collectVariants(@NotNull Module module, @NotNull String text, int offset, @NotNull String prefix) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/util/MvcTargetDialogCompletionUtils", "collectVariants"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/mvc/util/MvcTargetDialogCompletionUtils", "collectVariants"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/mvc/util/MvcTargetDialogCompletionUtils", "collectVariants"));
        }
        if (prefix.startsWith("-D")) {
            return MvcTargetDialogCompletionUtils.getSystemPropertiesVariants();
        }
        ArrayList<LookupElement> res = new ArrayList<LookupElement>();
        if (text.substring(0, offset).matches("\\s*(grails\\s*)?(?:(:?-D\\S+|dev|prod|test)\\s+)*\\S*")) {
            for (String completionVariant : MvcTargetDialogCompletionUtils.getAllTargetNames(module)) {
                res.add((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)completionVariant), (TailType)TailType.SPACE));
            }
        } else {
            PsiPackage defaultPackage;
            PsiPackage p;
            GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
            if (prefix.endsWith(".") && prefix.length() > 1 && (p = facade.findPackage(prefix.substring(0, prefix.length() - 1))) != null) {
                for (PsiClass aClass : p.getClasses(scope)) {
                    String qualifiedName = aClass.getQualifiedName();
                    if (qualifiedName == null) continue;
                    res.add((LookupElement)LookupElementBuilder.create((Object)aClass, (String)qualifiedName));
                }
            }
            if ((defaultPackage = facade.findPackage("")) != null) {
                MvcTargetDialogCompletionUtils.collectClassesAndPackageNames(res, defaultPackage, scope);
            }
        }
        return res;
    }

    private static void collectClassesAndPackageNames(Collection<LookupElement> res, @NotNull PsiPackage aPackage, GlobalSearchScope scope) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/mvc/util/MvcTargetDialogCompletionUtils", "collectClassesAndPackageNames"));
        }
        PsiPackage[] subPackages = aPackage.getSubPackages(scope);
        String qualifiedName = aPackage.getQualifiedName();
        if (qualifiedName.length() > 0 && (subPackages.length == 0 || aPackage.getClasses(scope).length > 0)) {
            res.add((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)qualifiedName), (TailType)TailType.DOT));
        }
        for (PsiPackage subPackage : subPackages) {
            MvcTargetDialogCompletionUtils.collectClassesAndPackageNames(res, subPackage, scope);
        }
    }

    public static Set<String> getAllTargetNamesInternal(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/util/MvcTargetDialogCompletionUtils", "getAllTargetNamesInternal"));
        }
        HashSet<String> result = new HashSet<String>();
        MvcFramework.addAvailableSystemScripts(result, module);
        MvcFramework framework = MvcFramework.getInstance(module);
        if (framework != null) {
            VirtualFile root = framework.findAppRoot(module);
            if (root != null) {
                MvcFramework.addAvailableScripts(result, root);
            }
            for (VirtualFile pluginRoot : framework.getAllPluginRoots(module, false)) {
                MvcFramework.addAvailableScripts(result, pluginRoot);
            }
        }
        MvcTargetDialogCompletionUtils.collectScriptsFromUserHome(result);
        return result;
    }

    private static void collectScriptsFromUserHome(Set<String> result) {
        String userHome = SystemProperties.getUserHome();
        if (userHome == null) {
            return;
        }
        File scriptFolder = new File(userHome, ".grails/scripts");
        File[] files = scriptFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.getName().startsWith("IdeaPrintProjectSettings") || !MvcTargetDialogCompletionUtils.isScriptFile(file)) continue;
            String name = file.getName();
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                name = name.substring(0, idx);
            }
            result.add(GroovyNamesUtil.camelToSnake(name));
        }
    }

    public static boolean isScriptFile(File file) {
        return file.isFile() && MvcFramework.isScriptFileName(file.getName());
    }

    public static Set<String> getAllTargetNames(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/util/MvcTargetDialogCompletionUtils", "getAllTargetNames"));
        }
        CachedValue cachedTargets = (CachedValue)module.getUserData(ALL_TARGET_KEY);
        if (cachedTargets == null) {
            cachedTargets = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Set<String>>(){

                public CachedValueProvider.Result<Set<String>> compute() {
                    return CachedValueProvider.Result.create(MvcTargetDialogCompletionUtils.getAllTargetNamesInternal(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
            cachedTargets = (CachedValue)((UserDataHolderEx)module).putUserDataIfAbsent(ALL_TARGET_KEY, (Object)cachedTargets);
        }
        return (Set)cachedTargets.getValue();
    }

    private static class MyTailTypeEQ
    extends TailType.TailTypeEQ {
        public static final MyTailTypeEQ INSTANCE = new MyTailTypeEQ();

        private MyTailTypeEQ() {
        }

        protected boolean isSpaceAroundAssignmentOperators(Editor editor, int tailOffset) {
            return false;
        }

        public String toString() {
            return "MvcTargetDialogCompletionUtils.TailTypeEQ";
        }
    }
}

