/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.MvcActionBase;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcRunTargetDialog;

public class MvcRunTarget
extends MvcActionBase {
    @Override
    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Module module, @NotNull MvcFramework framework) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcRunTarget", "actionPerformed"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/mvc/MvcRunTarget", "actionPerformed"));
        }
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/mvc/MvcRunTarget", "actionPerformed"));
        }
        MvcRunTargetDialog dialog = new MvcRunTargetDialog(module, framework);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        Module selectedModule = dialog.getSelectedModule();
        MvcCommand cmd = MvcCommand.parse(dialog.getTargetArguments());
        GeneralCommandLine commandLine = framework.createCommandAndShowErrors(dialog.getVmOptions(), selectedModule, cmd);
        if (commandLine == null) {
            return;
        }
        MvcConsole.executeProcess(selectedModule, commandLine, null, false, new String[0]);
    }
}

