/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;

public abstract class MvcProjectStructure {
    protected final Module myModule;
    private final boolean myAuxModule;
    private final String myUserHomeSdkRoot;
    private final String mySdkWorkDirPath;

    public MvcProjectStructure(Module module, boolean auxModule, String userHomeSdkRoot, File sdkWorkDir) {
        this.myAuxModule = auxModule;
        this.myModule = module;
        this.myUserHomeSdkRoot = userHomeSdkRoot;
        VirtualFile sdkWorkDirVFile = MvcModuleStructureUtil.refreshAndFind(sdkWorkDir);
        this.mySdkWorkDirPath = sdkWorkDirVFile == null ? "" : sdkWorkDirVFile.getPath() + "/";
    }

    public boolean isValidContentRoot(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructure", "isValidContentRoot"));
        }
        if (file.getPath().startsWith(this.myUserHomeSdkRoot)) {
            if (!this.myAuxModule) {
                return false;
            }
            if (!file.getPath().startsWith(this.mySdkWorkDirPath)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public abstract String getUserLibraryName();

    public abstract MultiMap<JpsModuleSourceRootType<?>, String> getSourceFolders();

    public abstract String[] getInvalidSourceFolders();

    public abstract String[] getExcludedFolders();

    public List<VirtualFile> getExcludedFolders(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructure", "getExcludedFolders"));
        }
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
        for (String excluded : this.getExcludedFolders()) {
            VirtualFile dir = root.findFileByRelativePath(excluded);
            if (dir == null) continue;
            res.add(dir);
        }
        return res;
    }

    public void setupFacets(Collection<Runnable> actions, Collection<VirtualFile> roots) {
    }
}

