/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.surroundWith.GroovyManyStatementsSurrounder;

public class GrBracesSurrounder
extends GroovyManyStatementsSurrounder {
    public String getTemplateDescription() {
        return "{}";
    }

    @Override
    protected GroovyPsiElement doSurroundElements(PsiElement[] elements, PsiElement context) throws IncorrectOperationException {
        GrCodeBlock block;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(elements[0].getProject());
        PsiElement e0 = elements[0];
        PsiElement parent = e0.getParent();
        if (parent instanceof GrControlStatement) {
            block = factory.createMethodBodyFromText("\n");
            PsiElement prev = e0.getPrevSibling();
            if (prev != null && prev.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) {
                ASTNode parentNode = e0.getParent().getNode();
                parentNode.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", prev.getNode());
                parentNode.removeChild(prev.getNode());
            }
        } else {
            block = factory.createClosureFromText("{}");
        }
        GroovyManyStatementsSurrounder.addStatements(block, elements);
        return block;
    }

    @Override
    protected TextRange getSurroundSelectionRange(GroovyPsiElement element) {
        int offset = element.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }
}

