/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class NonCodeMembersContributor {
    private static final ExtensionPointName<NonCodeMembersContributor> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.membersContributor");
    private static volatile MultiMap<String, NonCodeMembersContributor> ourClassSpecifiedContributors;
    private static NonCodeMembersContributor[] ourAllTypeContributors;

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor", "processDynamicElements"));
        }
        throw new RuntimeException("One of two 'processDynamicElements()' methods must be implemented");
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor", "processDynamicElements"));
        }
        this.processDynamicElements(qualifierType, processor, place, state);
    }

    @Nullable
    protected String getParentClassName() {
        return null;
    }

    private static void ensureInit() {
        if (ourClassSpecifiedContributors != null) {
            return;
        }
        MultiMap contributorMap = new MultiMap();
        for (NonCodeMembersContributor contributor : (NonCodeMembersContributor[])EP_NAME.getExtensions()) {
            contributorMap.putValue((Object)contributor.getParentClassName(), (Object)contributor);
        }
        Collection allTypeContributors = contributorMap.remove(null);
        ourAllTypeContributors = allTypeContributors.toArray(new NonCodeMembersContributor[allTypeContributors.size()]);
        ourClassSpecifiedContributors = contributorMap;
    }

    public static boolean runContributors(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor", "runContributors"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor", "runContributors"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor", "runContributors"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor", "runContributors"));
        }
        MyDelegatingScopeProcessor delegatingProcessor = new MyDelegatingScopeProcessor(processor);
        NonCodeMembersContributor.ensureInit();
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
        if (aClass != null) {
            for (String superClassName : TypesUtil.getSuperClassesWithCache(aClass).keySet()) {
                for (NonCodeMembersContributor enhancer : ourClassSpecifiedContributors.get((Object)superClassName)) {
                    enhancer.processDynamicElements(qualifierType, aClass, (PsiScopeProcessor)delegatingProcessor, place, state);
                    if (delegatingProcessor.wantMore) continue;
                    return false;
                }
            }
        }
        for (NonCodeMembersContributor contributor : ourAllTypeContributors) {
            contributor.processDynamicElements(qualifierType, aClass, (PsiScopeProcessor)delegatingProcessor, place, state);
            if (delegatingProcessor.wantMore) continue;
            return false;
        }
        return GroovyDslFileIndex.processExecutors(qualifierType, place, processor, state);
    }

    private static class MyDelegatingScopeProcessor
    extends DelegatingScopeProcessor {
        public boolean wantMore = true;

        public MyDelegatingScopeProcessor(PsiScopeProcessor delegate) {
            super(delegate);
        }

        public boolean execute(@NotNull PsiElement element, ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor$MyDelegatingScopeProcessor", "execute"));
            }
            if (!this.wantMore) {
                return false;
            }
            this.wantMore = super.execute(element, state);
            return this.wantMore;
        }
    }
}

