/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;

public class KnownRecursionManager {
    private final ThreadLocal<ThreadInfo> myThreads = new ThreadLocal<ThreadInfo>(){

        @Override
        protected ThreadInfo initialValue() {
            return new ThreadInfo();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Object key, Computable<T> computable, Object ... stopAt) {
        try {
            if (!this.startInference(key, stopAt)) {
                T t = null;
                return t;
            }
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            try {
                this.finishInference(key);
            }
            catch (Throwable e) {
                throw new RuntimeException("exception in finishInference", e);
            }
        }
    }

    private boolean startInference(Object key, Object[] stopAt) {
        ThreadInfo info = this.myThreads.get();
        for (Object o : stopAt) {
            if (!info.myObjects.contains(o)) continue;
            return false;
        }
        return info.myObjects.add(key);
    }

    private void finishInference(Object key) {
        ThreadInfo info = this.myThreads.get();
        info.myObjects.remove(key);
    }

    public static KnownRecursionManager getInstance() {
        return (KnownRecursionManager)ServiceManager.getService(KnownRecursionManager.class);
    }

    private static class ThreadInfo {
        private final Set<Object> myObjects = ContainerUtil.newLinkedHashSet();

        private ThreadInfo() {
        }
    }
}

