/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrInnerClassConstructorUtil {
    @NotNull
    public static GrParameter[] addEnclosingInstanceParam(@NotNull GrMethod method, @NotNull PsiClass enclosingClass, @NotNull GrParameter[] originalParams, boolean isOptional) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingInstanceParam"));
        }
        if (enclosingClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingInstanceParam"));
        }
        if (originalParams == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingInstanceParam"));
        }
        GrParameter[] parameters = new GrParameter[originalParams.length + 1];
        PsiClassType enclosingClassType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(enclosingClass, PsiSubstitutor.EMPTY);
        GrLightParameter enclosing = new GrLightParameter("enclosing", (PsiType)enclosingClassType, method);
        if (isOptional) {
            enclosing.setOptional(true);
            enclosing.setInitializerGroovy(GroovyPsiElementFactory.getInstance(method.getProject()).createExpressionFromText("null"));
        }
        parameters[0] = enclosing;
        System.arraycopy(originalParams, 0, parameters, 1, originalParams.length);
        if (parameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingInstanceParam"));
        }
        return parameters;
    }

    public static boolean isInnerClassConstructorUsedOutsideOfItParent(@NotNull PsiMethod method, PsiElement place) {
        PsiClass containingClass;
        PsiClass aClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "isInnerClassConstructorUsedOutsideOfItParent"));
        }
        return method instanceof GrMethod && method.isConstructor() && (aClass = method.getContainingClass()) != null && !aClass.hasModifierProperty("static") && (containingClass = aClass.getContainingClass()) != null && PsiUtil.findEnclosingInstanceClassInScope(containingClass, place, true) == null;
    }

    @NotNull
    public static PsiType[] addEnclosingArgIfNeeded(@NotNull PsiType[] types, @NotNull PsiElement place, @NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingArgIfNeeded"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingArgIfNeeded"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingArgIfNeeded"));
        }
        if (!aClass.hasModifierProperty("static") && (containingClass = aClass.getContainingClass()) != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
            PsiClass scopeClass = PsiUtil.findEnclosingInstanceClassInScope(containingClass, place, true);
            if (scopeClass != null) {
                PsiType[] newTypes = PsiType.createArray((int)(types.length + 1));
                newTypes[0] = factory.createType(scopeClass);
                System.arraycopy(types, 0, newTypes, 1, types.length);
                types = newTypes;
            } else if (types.length == 0 || !TypesUtil.isAssignableByMethodCallConversion((PsiType)factory.createType(containingClass), types[0], place)) {
                PsiType[] newTypes = PsiType.createArray((int)(types.length + 1));
                newTypes[0] = PsiType.NULL;
                System.arraycopy(types, 0, newTypes, 1, types.length);
                types = newTypes;
            }
        }
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrInnerClassConstructorUtil", "addEnclosingArgIfNeeded"));
        }
        return types;
    }
}

