/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public class MapEntryOrKeyValueHintProcessor
extends SignatureHintProcessor {
    @Override
    public String getHintName() {
        return "groovy.transform.stc.MapEntryOrKeyValue";
    }

    @Override
    @NotNull
    public List<PsiType[]> inferExpectedSignatures(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull String[] options) {
        PsiType[] psiTypeArray;
        PsiType[] psiTypeArray2;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor", "inferExpectedSignatures"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor", "inferExpectedSignatures"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor", "inferExpectedSignatures"));
        }
        int argNum = MapEntryOrKeyValueHintProcessor.extractArgNum(options);
        boolean index = MapEntryOrKeyValueHintProcessor.extractIndex(options);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (argNum >= parameters.length) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor", "inferExpectedSignatures"));
            }
            return list;
        }
        PsiParameter parameter = parameters[argNum];
        PsiType type = parameter.getType();
        PsiType substituted = substitutor.substitute(type);
        if (!InheritanceUtil.isInheritor((PsiType)substituted, (String)"java.util.Map")) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor", "inferExpectedSignatures"));
            }
            return list;
        }
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)substituted, (String)"java.util.Map", (int)0, (boolean)true);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)substituted, (String)"java.util.Map", (int)1, (boolean)true);
        PsiClass mapEntry = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.util.Map.Entry", method.getResolveScope());
        if (mapEntry == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor", "inferExpectedSignatures"));
            }
            return list;
        }
        PsiClassType mapEntryType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(mapEntry, new PsiType[]{key, value});
        if (index) {
            PsiType[] psiTypeArray3 = new PsiType[3];
            psiTypeArray3[0] = key;
            psiTypeArray3[1] = value;
            psiTypeArray2 = psiTypeArray3;
            psiTypeArray3[2] = PsiType.INT;
        } else {
            PsiType[] psiTypeArray4 = new PsiType[2];
            psiTypeArray4[0] = key;
            psiTypeArray2 = psiTypeArray4;
            psiTypeArray4[1] = value;
        }
        PsiType[] keyValueSignature = psiTypeArray2;
        if (index) {
            PsiType[] psiTypeArray5 = new PsiType[2];
            psiTypeArray5[0] = mapEntryType;
            psiTypeArray = psiTypeArray5;
            psiTypeArray5[1] = PsiType.INT;
        } else {
            PsiType[] psiTypeArray6 = new PsiType[1];
            psiTypeArray = psiTypeArray6;
            psiTypeArray6[0] = mapEntryType;
        }
        PsiType[] mapEntrySignature = psiTypeArray;
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new PsiType[][]{keyValueSignature, mapEntrySignature});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/MapEntryOrKeyValueHintProcessor", "inferExpectedSignatures"));
        }
        return arrayList;
    }

    private static int extractArgNum(String[] options) {
        for (String value : options) {
            Integer parsedValue = MapEntryOrKeyValueHintProcessor.parseArgNum(value);
            if (parsedValue == null) continue;
            return parsedValue;
        }
        if (options.length == 1) {
            return StringUtilRt.parseInt((String)options[0], (int)0);
        }
        return 0;
    }

    private static boolean extractIndex(String[] options) {
        for (String value : options) {
            Boolean parsedValue = MapEntryOrKeyValueHintProcessor.parseIndex(value);
            if (parsedValue == null) continue;
            return parsedValue;
        }
        if (options.length == 1) {
            return StringUtilRt.parseBoolean((String)options[0], (boolean)false);
        }
        return false;
    }

    private static Boolean parseIndex(String value) {
        Pair<String, String> pair = MapEntryOrKeyValueHintProcessor.parseValue(value);
        if (pair == null) {
            return null;
        }
        Boolean parsedValue = StringUtilRt.parseBoolean((String)((String)pair.getSecond()), (boolean)false);
        if ("index".equals(pair.getFirst())) {
            return parsedValue;
        }
        return null;
    }

    private static Integer parseArgNum(String value) {
        Pair<String, String> pair = MapEntryOrKeyValueHintProcessor.parseValue(value);
        if (pair == null) {
            return null;
        }
        Integer parsedValue = StringUtilRt.parseInt((String)((String)pair.getSecond()), (int)0);
        if ("argNum".equals(pair.getFirst())) {
            return parsedValue;
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> parseValue(String value) {
        String[] splitted = value.split("=");
        if (splitted.length == 2) {
            return Pair.create((Object)splitted[0].trim(), (Object)splitted[1].trim());
        }
        return null;
    }
}

