/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeConverter {
    public static final ExtensionPointName<GrTypeConverter> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.typeConverter");

    protected static boolean isMethodCallConversion(GroovyPsiElement context) {
        return PsiUtil.isInMethodCallContext(context);
    }

    public abstract boolean isAllowedInMethodCall();

    @Nullable
    public abstract Boolean isConvertible(@NotNull PsiType var1, @NotNull PsiType var2, @NotNull GroovyPsiElement var3);

    protected static boolean isEnum(PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            return resolved != null && resolved.isEnum();
        }
        return false;
    }

    public static Boolean isConvertibleWithMethodCallConversion(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleWithMethodCallConversion"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleWithMethodCallConversion"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleWithMethodCallConversion"));
        }
        for (GrTypeConverter converter : (GrTypeConverter[])EP_NAME.getExtensions()) {
            Boolean result;
            if (!converter.isAllowedInMethodCall() || (result = converter.isConvertible(lType, rType, context)) == null) continue;
            return result;
        }
        return null;
    }

    public static Boolean isConvertibleAll(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleAll"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleAll"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter", "isConvertibleAll"));
        }
        for (GrTypeConverter converter : (GrTypeConverter[])EP_NAME.getExtensions()) {
            Boolean result;
            if (converter.isAllowedInMethodCall() || (result = converter.isConvertible(lType, rType, context)) == null) continue;
            return result;
        }
        return null;
    }
}

