/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrStringTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isAllowedInMethodCall() {
        return false;
    }

    @Override
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrStringTypeConverter", "isConvertible"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrStringTypeConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrStringTypeConverter", "isConvertible"));
        }
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(context, "1.8")) {
            return null;
        }
        if (!InheritanceUtil.isInheritor((PsiType)rType, (String)"java.lang.CharSequence") && !InheritanceUtil.isInheritor((PsiType)rType, (String)"groovy.lang.GString")) {
            return null;
        }
        if (lType == PsiType.BOOLEAN || TypesUtil.resolvesTo(lType, "java.lang.Boolean")) {
            return true;
        }
        if (TypesUtil.resolvesTo(lType, "java.lang.Class")) {
            return true;
        }
        if (GrStringTypeConverter.isEnum(lType)) {
            return true;
        }
        return null;
    }
}

