/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrStringConverter
extends GrTypeConverter {
    @Override
    public boolean isAllowedInMethodCall() {
        return false;
    }

    @Override
    @Nullable
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrStringConverter", "isConvertible"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrStringConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrStringConverter", "isConvertible"));
        }
        if (TypesUtil.isClassType(lType, "java.lang.String")) {
            return Boolean.TRUE;
        }
        if (TypesUtil.unboxPrimitiveTypeWrapper(lType) == PsiType.CHAR && (TypesUtil.isClassType(rType, "java.lang.String") || TypesUtil.isClassType(rType, "groovy.lang.GString"))) {
            return Boolean.TRUE;
        }
        return null;
    }
}

