/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class ClosureToSamConverter
extends GrTypeConverter {
    private static final LightCacheKey<Ref<MethodSignature>> SAM_SIGNATURE_LIGHT_CACHE_KEY = LightCacheKey.createByJavaModificationCount();

    @Override
    public boolean isAllowedInMethodCall() {
        return true;
    }

    @Override
    public Boolean isConvertible(@NotNull PsiType ltype, @NotNull PsiType rtype, @NotNull GroovyPsiElement context) {
        MethodSignature signature;
        if (ltype == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "isConvertible"));
        }
        if (rtype == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "isConvertible"));
        }
        if (rtype instanceof GrClosureType && ltype instanceof PsiClassType && ClosureToSamConverter.isSamConversionAllowed(context) && !TypesUtil.isClassType(ltype, "groovy.lang.Closure") && (signature = ClosureToSamConverter.findSAMSignature(ltype)) != null) {
            PsiType[] samParameterTypes = signature.getParameterTypes();
            GrSignature closureSignature = ((GrClosureType)rtype).getSignature();
            boolean raw = ((PsiClassType)ltype).isRaw();
            if (raw) {
                return true;
            }
            if (GrClosureSignatureUtil.isSignatureApplicable(closureSignature, samParameterTypes, context)) {
                return true;
            }
        }
        return null;
    }

    public static boolean isSamConversionAllowed(PsiElement context) {
        return GroovyConfigUtils.getInstance().isVersionAtLeast(context, "2.2");
    }

    @Nullable
    public static MethodSignature findSingleAbstractMethod(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor) {
        MethodSignature signature;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "findSingleAbstractMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "findSingleAbstractMethod"));
        }
        Ref<MethodSignature> cached = SAM_SIGNATURE_LIGHT_CACHE_KEY.getCachedValue((PsiElement)aClass);
        if (cached != null) {
            signature = (MethodSignature)cached.get();
        } else {
            Ref newCached = Ref.create((Object)ClosureToSamConverter.doFindSingleAbstractMethodClass(aClass));
            signature = (MethodSignature)SAM_SIGNATURE_LIGHT_CACHE_KEY.putCachedValue((PsiElement)aClass, (Ref<MethodSignature>)newCached).get();
        }
        return signature != null ? ClosureToSamConverter.substitute(signature, substitutor) : null;
    }

    @Nullable
    private static MethodSignature doFindSingleAbstractMethodClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "doFindSingleAbstractMethodClass"));
        }
        Collection toImplement = OverrideImplementExploreUtil.getMethodSignaturesToImplement((PsiClass)aClass);
        if (toImplement.size() > 1) {
            return null;
        }
        MethodSignature abstractSignature = toImplement.isEmpty() ? null : (MethodSignature)toImplement.iterator().next();
        for (PsiMethod method : aClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            if (abstractSignature != null) {
                return null;
            }
            abstractSignature = method.getSignature(PsiSubstitutor.EMPTY);
        }
        return abstractSignature;
    }

    @NotNull
    private static MethodSignature substitute(@NotNull MethodSignature signature, @NotNull PsiSubstitutor substitutor) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "substitute"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "substitute"));
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature((String)signature.getName(), (PsiType[])signature.getParameterTypes(), (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)substitutor, (boolean)false);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureToSamConverter", "substitute"));
        }
        return methodSignature;
    }

    @Nullable
    public static MethodSignature findSAMSignature(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            if (TypesUtil.isClassType(type, "groovy.lang.Closure")) {
                return null;
            }
            PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                return ClosureToSamConverter.findSingleAbstractMethod(aClass, result.getSubstitutor());
            }
        }
        return null;
    }
}

