/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;

public class GrAnnotationStub
extends StubBase<GrAnnotation> {
    private static final Logger LOG = Logger.getInstance(GrAnnotationStub.class);
    private final String myText;
    private SoftReference<GrAnnotation> myPsiRef;

    public GrAnnotationStub(StubElement parent, String text) {
        super(parent, GroovyElementTypes.ANNOTATION);
        this.myText = text;
    }

    public GrAnnotationStub(StubElement parent, GrAnnotation from) {
        super(parent, GroovyElementTypes.ANNOTATION);
        this.myText = from.getText();
    }

    public GrAnnotation getPsiElement() {
        GrAnnotation annotation = (GrAnnotation)SoftReference.dereference(this.myPsiRef);
        if (annotation != null) {
            return annotation;
        }
        try {
            annotation = GroovyPsiElementFactory.getInstance(this.getProject()).createAnnotationFromText(this.myText, this.getPsi());
            this.myPsiRef = new SoftReference((Object)annotation);
            return annotation;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in repository!", (Throwable)e);
            return null;
        }
    }

    public String getText() {
        return this.myText;
    }
}

