/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.LightJavaToken;

public class GrSyntheticCodeBlock
extends LightElement
implements PsiCodeBlock {
    private static final Logger LOG = Logger.getInstance(GrSyntheticCodeBlock.class);
    private GrCodeBlock myCodeBlock;
    private static final Key<SoftReference<PsiJavaToken>> PSI_JAVA_TOKEN = Key.create((String)"psi_java_token");

    public GrSyntheticCodeBlock(@NotNull GrCodeBlock codeBlock) {
        if (codeBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrSyntheticCodeBlock", "<init>"));
        }
        super(codeBlock.getManager(), codeBlock.getLanguage());
        this.myCodeBlock = codeBlock;
    }

    public String toString() {
        return "code block wrapper to represent java codeBlock";
    }

    @NotNull
    public PsiStatement[] getStatements() {
        if (PsiStatement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrSyntheticCodeBlock", "getStatements"));
        }
        return PsiStatement.EMPTY_ARRAY;
    }

    public PsiElement getFirstBodyElement() {
        PsiElement nextSibling = this.myCodeBlock.getLBrace().getNextSibling();
        return nextSibling == this.getRBrace() ? null : nextSibling;
    }

    public PsiElement getLastBodyElement() {
        PsiElement rBrace = this.myCodeBlock.getRBrace();
        if (rBrace != null) {
            PsiElement prevSibling = rBrace.getPrevSibling();
            return prevSibling == this.myCodeBlock.getLBrace() ? null : prevSibling;
        }
        return this.getLastChild();
    }

    public PsiJavaToken getLBrace() {
        return GrSyntheticCodeBlock.getOrCreateJavaToken(this.myCodeBlock.getLBrace(), JavaTokenType.LBRACE);
    }

    public PsiJavaToken getRBrace() {
        return GrSyntheticCodeBlock.getOrCreateJavaToken(this.myCodeBlock.getRBrace(), JavaTokenType.RBRACE);
    }

    @Nullable
    private static PsiJavaToken getOrCreateJavaToken(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrSyntheticCodeBlock", "getOrCreateJavaToken"));
        }
        if (element == null) {
            return null;
        }
        SoftReference ref = (SoftReference)element.getUserData(PSI_JAVA_TOKEN);
        PsiJavaToken token = (PsiJavaToken)SoftReference.dereference((Reference)ref);
        if (token != null) {
            return token;
        }
        LightJavaToken newToken = new LightJavaToken(element, type);
        element.putUserData(PSI_JAVA_TOKEN, (Object)new SoftReference((Object)newToken));
        return newToken;
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrSyntheticCodeBlock", "replace"));
        }
        if (newElement instanceof GrSyntheticCodeBlock) {
            GrSyntheticCodeBlock other = (GrSyntheticCodeBlock)newElement;
            PsiElement replaced = this.myCodeBlock.replace(other.myCodeBlock);
            LOG.assertTrue(replaced instanceof GrOpenBlock);
            return PsiImplUtil.getOrCreatePsiCodeBlock((GrOpenBlock)replaced);
        }
        return super.replace(newElement);
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }

    public TextRange getTextRange() {
        return this.myCodeBlock.getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.myCodeBlock.getStartOffsetInParent();
    }

    public PsiFile getContainingFile() {
        return this.myCodeBlock.getContainingFile();
    }

    public int getTextOffset() {
        return this.myCodeBlock.getTextOffset();
    }

    public String getText() {
        return this.myCodeBlock.getText();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        GrCodeBlock grCodeBlock = this.myCodeBlock;
        if (grCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrSyntheticCodeBlock", "getNavigationElement"));
        }
        return grCodeBlock;
    }

    public boolean isValid() {
        return this.myCodeBlock.isValid();
    }

    public void delete() throws IncorrectOperationException {
        this.myCodeBlock.delete();
    }
}

