/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;

public class GrTypeDefinitionMembersCache {
    private static final Condition<PsiMethod> CONSTRUCTOR_CONDITION = new Condition<PsiMethod>(){

        public boolean value(PsiMethod method) {
            return method.isConstructor();
        }
    };
    private final MyModificationTracker myTreeChangeTracker = new MyModificationTracker();
    private final GrTypeDefinition myDefinition;

    public GrTypeDefinitionMembersCache(GrTypeDefinition definition) {
        this.myDefinition = definition;
    }

    public GrMethod[] getCodeMethods() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrMethod[]>(){

            @Nullable
            public CachedValueProvider.Result<GrMethod[]> compute() {
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                GrMethod[] methods = body != null ? body.getMethods() : GrMethod.EMPTY_ARRAY;
                return CachedValueProvider.Result.create((Object)methods, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public GrMethod[] getCodeConstructors() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrMethod[]>(){

            @Nullable
            public CachedValueProvider.Result<GrMethod[]> compute() {
                GrMethod[] methods;
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                if (body != null) {
                    List result = ContainerUtil.findAll((Object[])body.getMethods(), (Condition)CONSTRUCTOR_CONDITION);
                    methods = result.toArray(new GrMethod[result.size()]);
                } else {
                    methods = GrMethod.EMPTY_ARRAY;
                }
                return CachedValueProvider.Result.create((Object)methods, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public PsiMethod[] getConstructors() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiMethod[]> compute() {
                List result = ContainerUtil.findAll((Object[])GrTypeDefinitionMembersCache.this.myDefinition.getMethods(), (Condition)CONSTRUCTOR_CONDITION);
                return CachedValueProvider.Result.create((Object)result.toArray(new PsiMethod[result.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public PsiClass[] getInnerClasses() {
        return (PsiClass[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiClass[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiClass[]> compute() {
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                PsiClass[] inners = body != null ? body.getInnerClasses() : PsiClass.EMPTY_ARRAY;
                return CachedValueProvider.Result.create((Object)inners, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public GrField[] getFields() {
        return (GrField[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrField[]>(){

            @Nullable
            public CachedValueProvider.Result<GrField[]> compute() {
                return CachedValueProvider.Result.create((Object)GrTypeDefinitionMembersCache.this.getFieldsImpl(), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    private GrField[] getFieldsImpl() {
        GrField[] codeFields = this.myDefinition.getCodeFields();
        List<GrField> fromAstTransform = this.getSyntheticFields();
        if (fromAstTransform.isEmpty()) {
            return codeFields;
        }
        GrField[] res = new GrField[codeFields.length + fromAstTransform.size()];
        System.arraycopy(codeFields, 0, res, 0, codeFields.length);
        for (int i = 0; i < fromAstTransform.size(); ++i) {
            res[codeFields.length + i] = fromAstTransform.get(i);
        }
        return res;
    }

    private List<GrField> getSyntheticFields() {
        return (List)CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<List<GrField>>(){

            @Nullable
            public CachedValueProvider.Result<List<GrField>> compute() {
                return CachedValueProvider.Result.create(AstTransformContributor.runContributorsForFields(GrTypeDefinitionMembersCache.this.myDefinition), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public PsiMethod[] getMethods() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
                GrClassImplUtil.collectMethodsFromBody(GrTypeDefinitionMembersCache.this.myDefinition, result);
                for (PsiMethod method : AstTransformContributor.runContributorsForMethods(GrTypeDefinitionMembersCache.this.myDefinition)) {
                    GrClassImplUtil.addExpandingReflectedMethods(result, method);
                }
                for (GrField field : GrTypeDefinitionMembersCache.this.getSyntheticFields()) {
                    ContainerUtil.addIfNotNull(result, (Object)field.getSetter());
                    Collections.addAll(result, field.getGetters());
                }
                return CachedValueProvider.Result.create((Object)result.toArray(new PsiMethod[result.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public void dropCaches() {
        this.myTreeChangeTracker.inc();
    }

    private static class MyModificationTracker
    implements ModificationTracker {
        private long myCount = 0L;

        private MyModificationTracker() {
        }

        public long getModificationCount() {
            return this.myCount;
        }

        public void inc() {
            ++this.myCount;
        }
    }
}

