/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrParameterStub;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;
import org.jetbrains.plugins.groovy.lang.resolve.KnownRecursionManager;

public class GrParameterImpl
extends GrVariableBaseImpl<GrParameterStub>
implements GrParameter,
StubBasedPsiElement<GrParameterStub> {
    public GrParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "<init>"));
        }
        super(node);
    }

    public GrParameterImpl(GrParameterStub stub) {
        super(stub, GroovyElementTypes.PARAMETER);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitParameter(this);
    }

    public String toString() {
        return "Parameter";
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        PsiType declaredType = this.getDeclaredType();
        if (declaredType != null) {
            return declaredType;
        }
        if (this.isVarArgs()) {
            PsiClassType type = TypesUtil.getJavaLangObject(this);
            return new PsiEllipsisType((PsiType)type);
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrForInClause) {
            GrExpression iteratedExpression = ((GrForInClause)parent).getIteratedExpression();
            if (iteratedExpression == null) {
                return null;
            }
            PsiType result = ClosureParameterEnhancer.findTypeForIteration(iteratedExpression, (PsiElement)this);
            if (result != null) {
                return result;
            }
        } else {
            if (parent instanceof GrTraditionalForClause) {
                return super.getTypeGroovy();
            }
            if (parent instanceof GrCatchClause) {
                return TypesUtil.createTypeByFQClassName("java.lang.Exception", this);
            }
        }
        return KnownRecursionManager.getInstance().run(this, new Computable<PsiType>(){

            public PsiType compute() {
                return GrVariableEnhancer.getEnhancedType(GrParameterImpl.this);
            }
        }, this.getDeclarationScope());
    }

    @Override
    public PsiType getDeclaredType() {
        PsiType type = super.getDeclaredType();
        if (this.isVarArgs()) {
            if (type == null) {
                type = TypesUtil.getJavaLangObject(this);
            }
            return new PsiEllipsisType(type);
        }
        return type;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType type = super.getType();
        if (this.isMainMethodFirstUntypedParameter()) {
            PsiArrayType psiArrayType = TypesUtil.createTypeByFQClassName("java.lang.String", this).createArrayType();
            if (psiArrayType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getType"));
            }
            return psiArrayType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getType"));
        }
        return psiType;
    }

    private boolean isMainMethodFirstUntypedParameter() {
        if (this.getTypeElementGroovy() != null) {
            return false;
        }
        if (!(this.getParent() instanceof GrParameterList)) {
            return false;
        }
        if (this.getInitializerGroovy() != null) {
            return false;
        }
        GrParameterList parameterList = (GrParameterList)this.getParent();
        if (!(parameterList.getParent() instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)parameterList.getParent();
        return PsiImplUtil.isMainMethod(method);
    }

    @Override
    public void setType(@Nullable PsiType type) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (type == null) {
            if (typeElement != null) {
                typeElement.delete();
            }
            return;
        }
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (typeElement == null) {
            GrModifierList modifierList = this.getModifierList();
            newTypeElement = (GrTypeElement)this.addAfter(newTypeElement, modifierList);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(newTypeElement);
        }
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    @Nullable
    public GrTypeElement getTypeElementGroovy() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            String typeText = stub.getTypeText();
            if (typeText == null) {
                return null;
            }
            return GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(typeText, this);
        }
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    public boolean isOptional() {
        return this.getInitializerGroovy() != null;
    }

    @Override
    @Nullable
    public PsiElement getEllipsisDots() {
        return this.findChildByType(GroovyTokenTypes.mTRIPLE_DOT);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GrDocCommentOwner owner;
        GrDocComment comment;
        if (!this.isPhysical()) {
            PsiFile file = this.getContainingFile();
            PsiElement context = file.getContext();
            if (context != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope(context);
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getUseScope"));
                }
                return localSearchScope;
            }
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getUseScope"));
            }
            return searchScope;
        }
        PsiElement scope = this.getDeclarationScope();
        if (scope instanceof GrDocCommentOwner && (comment = (owner = (GrDocCommentOwner)scope).getDocComment()) != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope(new PsiElement[]{scope, comment});
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(scope);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    @Override
    @NotNull
    public String getName() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getName"));
            }
            return string;
        }
        String string = super.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = (GrModifierList)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS);
        if (grModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getModifierList"));
        }
        return grModifierList;
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        GrParametersOwner owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GrParametersOwner.class);
        assert (owner != null);
        if (owner instanceof GrForClause) {
            PsiElement psiElement = owner.getParent();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        GrParametersOwner grParametersOwner = owner;
        if (grParametersOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl", "getDeclarationScope"));
        }
        return grParametersOwner;
    }

    public boolean isVarArgs() {
        PsiElement dots = this.getEllipsisDots();
        return dots != null;
    }
}

