/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.lang.ASTNode;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrAbstractLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralEscaper;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrStringImpl
extends GrAbstractLiteral
implements GrString {
    public GrStringImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrStringImpl", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "Compound Gstring";
    }

    @Override
    public PsiType getType() {
        return this.getTypeByFQName(this.findChildByClass(GrStringInjection.class) != null ? "groovy.lang.GString" : "java.lang.String");
    }

    @Override
    public boolean isPlainString() {
        return !this.getText().startsWith("\"\"\"");
    }

    @Override
    public GrStringInjection[] getInjections() {
        return (GrStringInjection[])this.findChildrenByClass(GrStringInjection.class);
    }

    @Override
    public String[] getTextParts() {
        List parts = this.findChildrenByType(GroovyElementTypes.GSTRING_CONTENT);
        String[] result = new String[parts.size()];
        int i = 0;
        for (PsiElement part : parts) {
            result[i++] = part.getText();
        }
        return result;
    }

    @Override
    public GrStringContent[] getContents() {
        List parts = this.findChildrenByType(GroovyElementTypes.GSTRING_CONTENT);
        return parts.toArray(new GrStringContent[parts.size()]);
    }

    @Override
    public GroovyPsiElement[] getAllContentParts() {
        List result = this.findChildrenByType(TokenSets.GSTRING_CONTENT_PARTS);
        return result.toArray(new GroovyPsiElement[result.size()]);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitGStringExpression(this);
    }

    public Object getValue() {
        StringBuilder chars;
        if (this.findChildByClass(GrStringInjection.class) != null) {
            return null;
        }
        PsiElement fchild = this.getFirstChild();
        if (fchild == null) {
            return null;
        }
        PsiElement content = fchild.getNextSibling();
        if (content == null || content.getNode().getElementType() != GroovyElementTypes.GSTRING_CONTENT) {
            return null;
        }
        String text = content.getText();
        boolean result = GrStringUtil.parseStringCharacters(text, chars = new StringBuilder(text.length()), null);
        return result ? chars.toString() : null;
    }

    public boolean isValidHost() {
        return false;
    }

    @Override
    public GrStringImpl updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrStringImpl", "updateText"));
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        GrLiteralEscaper grLiteralEscaper = new GrLiteralEscaper(this);
        if (grLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrStringImpl", "createLiteralTextEscaper"));
        }
        return grLiteralEscaper;
    }
}

