/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessInspection;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrReferenceResolveUtil {
    private GrReferenceResolveUtil() {
    }

    static boolean resolveImpl(ResolverProcessor processor, GrReferenceExpression place) {
        GrExpression qualifier = (GrExpression)place.getQualifier();
        if (qualifier == null) {
            GrExpression runtimeQualifier;
            if (!ResolveUtil.treeWalkUp(place, processor, true)) {
                return false;
            }
            if (!processor.hasCandidates() && (runtimeQualifier = PsiImplUtil.getRuntimeQualifier(place)) != null && !GrReferenceResolveUtil.processQualifier(processor, runtimeQualifier, place)) {
                return false;
            }
        } else {
            if (place.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
                ResolveState state;
                PsiType qtype = qualifier.getType();
                PsiType componentType = ClosureParameterEnhancer.findTypeForIteration(qtype, (PsiElement)place);
                if (componentType != null && !GrReferenceResolveUtil.processQualifierType(processor, componentType, state = ResolveState.initial().put(ResolverProcessor.RESOLVE_CONTEXT, (Object)qualifier).put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qtype, null)), place)) {
                    return false;
                }
            } else {
                if (GrUnresolvedAccessInspection.isClassReference(place)) {
                    return true;
                }
                if (!GrReferenceResolveUtil.processQualifier(processor, qualifier, place)) {
                    return false;
                }
            }
            if (qualifier instanceof GrReferenceExpression && ("class".equals(((GrReferenceExpression)qualifier).getReferenceName()) || PsiUtil.isThisReference(qualifier)) && !GrReferenceResolveUtil.processIfJavaLangClass(processor, qualifier.getType(), qualifier, place)) {
                return false;
            }
        }
        return true;
    }

    private static boolean processIfJavaLangClass(ResolverProcessor processor, @Nullable PsiType type, GroovyPsiElement resolveContext, GrReferenceExpression place) {
        if (!(type instanceof PsiClassType)) {
            return true;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null || !"java.lang.Class".equals(psiClass.getQualifiedName())) {
            return true;
        }
        PsiType[] params = ((PsiClassType)type).getParameters();
        if (params.length != 1) {
            return true;
        }
        return GrReferenceResolveUtil.processQualifierType(processor, params[0], ResolveState.initial().put(ResolverProcessor.RESOLVE_CONTEXT, (Object)resolveContext), place);
    }

    public static boolean processQualifier(PsiScopeProcessor processor, GrExpression qualifier, GrReferenceExpression place) {
        PsiType qualifierType = qualifier.getType();
        ResolveState state = ResolveState.initial().put(ResolverProcessor.RESOLVE_CONTEXT, (Object)qualifier);
        if (qualifierType == null || qualifierType == PsiType.VOID) {
            if (qualifier instanceof GrReferenceExpression) {
                PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                if (resolved != null && !resolved.processDeclarations(processor, state, null, (PsiElement)place)) {
                    return false;
                }
                if (!(resolved instanceof PsiPackage) && !GrReferenceResolveUtil.processQualifierType(processor, qualifierType = TypesUtil.getJavaLangObject(place), state, place)) {
                    return false;
                }
            }
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                if (GrReferenceResolveUtil.processQualifierType(processor, conjunct, state, place)) continue;
                return false;
            }
        } else {
            PsiClass javaLangClass;
            PsiElement resolved;
            if (!GrReferenceResolveUtil.processQualifierType(processor, qualifierType, state, place)) {
                return false;
            }
            if (qualifier instanceof GrReferenceExpression && !PsiUtil.isSuperReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass && (javaLangClass = PsiUtil.getJavaLangClass(resolved, place.getResolveScope())) != null) {
                PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
                PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
                if (substitutor == null) {
                    substitutor = PsiSubstitutor.EMPTY;
                }
                if (typeParameters.length == 1) {
                    substitutor = substitutor.put(typeParameters[0], qualifierType);
                    state = state.put(PsiSubstitutor.KEY, (Object)substitutor);
                }
                if (!javaLangClass.processDeclarations(processor, state, null, (PsiElement)place)) {
                    return false;
                }
                PsiType javaLangClassType = TypesUtil.createJavaLangClassType(qualifierType, place.getProject(), place.getResolveScope());
                if (javaLangClassType != null && !ResolveUtil.processNonCodeMembers(javaLangClassType, processor, place, state)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processQualifierType(PsiScopeProcessor processor, PsiType originalQualifierType, ResolveState state, GrReferenceExpression place) {
        PsiType componentType;
        GroovyPsiManager gmanager;
        GrTypeDefinition arrayClass;
        PsiClassType.ClassResolveResult qualifierResult;
        PsiClass qualifierClass;
        PsiType qualifierType;
        PsiType psiType = qualifierType = originalQualifierType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)originalQualifierType).getLeastUpperBound() : originalQualifierType;
        if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                if (GrReferenceResolveUtil.processQualifierType(processor, conjunct, state, place)) continue;
                return false;
            }
            return true;
        }
        if (qualifierType instanceof PsiClassType ? (qualifierClass = (qualifierResult = ((PsiClassType)qualifierType).resolveGenerics()).getElement()) != null && !qualifierClass.processDeclarations(processor, state.put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor()), null, (PsiElement)place) : qualifierType instanceof PsiArrayType && (arrayClass = (gmanager = GroovyPsiManager.getInstance(place.getProject())).getArrayClass(((PsiArrayType)qualifierType).getComponentType())) != null && !arrayClass.processDeclarations(processor, state, null, place)) {
            return false;
        }
        if (!(place.getParent() instanceof GrMethodCall) && InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Collection") && (componentType = ClosureParameterEnhancer.findTypeForIteration(qualifierType, (PsiElement)place)) != null) {
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            GrReferenceResolveUtil.processQualifierType(processor, componentType, state.put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qualifierType, spreadState)), place);
        }
        if (!ResolveUtil.processCategoryMembers(place, processor, state)) {
            return false;
        }
        return ResolveUtil.processNonCodeMembers(qualifierType, processor, place, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PsiType getQualifierType(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveUtil", "getQualifierType"));
        }
        GrExpression rtQualifier = PsiImplUtil.getRuntimeQualifier(ref);
        if (rtQualifier != null) {
            return rtQualifier.getType();
        }
        PsiClass containingClass = null;
        GrMember member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)ref, GrMember.class);
        if (member == null) {
            PsiFile file = ref.getContainingFile();
            if (!(file instanceof GroovyFileBase) || !((GroovyFileBase)file).isScript()) return null;
            containingClass = ((GroovyFileBase)file).getScriptClass();
        } else if (member instanceof GrMethod && !member.hasModifierProperty("static")) {
            containingClass = member.getContainingClass();
        }
        if (containingClass == null) return null;
        PsiClassType categoryType = GdkMethodUtil.getCategoryType(containingClass);
        if (categoryType == null) return JavaPsiFacade.getElementFactory((Project)ref.getProject()).createType(containingClass);
        return categoryType;
    }

    public static boolean resolveThisExpression(GrReferenceExpression ref, List<GroovyResolveResult> results) {
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier == null) {
            PsiElement parent = ref.getParent();
            if (parent instanceof GrConstructorInvocation) {
                Object[] res = ((GrConstructorInvocation)parent).multiResolve(false);
                ContainerUtil.addAll(results, (Object[])res);
                return true;
            }
            PsiClass aClass = PsiUtil.getContextClass(ref);
            if (aClass == null) {
                return false;
            }
            results.add(new GroovyResolveResultImpl((PsiElement)aClass, null, null, PsiSubstitutor.EMPTY, true, true));
            return true;
        }
        if (!(qualifier instanceof GrReferenceExpression)) {
            return false;
        }
        GroovyResolveResult result = ((GrReferenceExpression)qualifier).advancedResolve();
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiClass)) {
            return false;
        }
        if (!PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, ref, false)) {
            return false;
        }
        results.add(result);
        return true;
    }

    public static boolean resolveSuperExpression(GrReferenceExpression ref, List<GroovyResolveResult> results) {
        PsiClass superClass;
        PsiClass aClass;
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier == null) {
            PsiElement parent = ref.getParent();
            if (parent instanceof GrConstructorInvocation) {
                Object[] res = ((GrConstructorInvocation)parent).multiResolve(false);
                ContainerUtil.addAll(results, (Object[])res);
                return true;
            }
            aClass = PsiUtil.getContextClass(ref);
            if (aClass == null) {
                return false;
            }
        } else {
            if (!(qualifier instanceof GrReferenceExpression)) {
                return false;
            }
            GroovyResolveResult result = ((GrReferenceExpression)qualifier).advancedResolve();
            PsiElement resolved = result.getElement();
            if (!(resolved instanceof PsiClass)) {
                return false;
            }
            if (!PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, ref, false)) {
                return false;
            }
            aClass = (PsiClass)resolved;
        }
        if ((superClass = aClass.getSuperClass()) == null) {
            return true;
        }
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        results.add(new GroovyResolveResultImpl((PsiElement)superClass, null, null, superClassSubstitutor, true, true));
        return true;
    }
}

