/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceResolveUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class CompleteReferenceExpression {
    private CompleteReferenceExpression() {
    }

    public static void processVariants(@NotNull PrefixMatcher matcher, final @NotNull Consumer<LookupElement> consumer, @NotNull GrReferenceExpressionImpl refExpr, @NotNull CompletionParameters parameters) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processVariants"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processVariants"));
        }
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processVariants"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processVariants"));
        }
        CompleteReferenceExpression.processRefInAnnotation(refExpr, matcher, consumer);
        final int[] count = new int[]{0};
        CompleteReferenceProcessor processor = new CompleteReferenceProcessor(refExpr, new Consumer<LookupElement>(){

            public void consume(LookupElement element) {
                count[0] = count[0] + 1;
                consumer.consume((Object)element);
            }
        }, matcher, parameters);
        CompleteReferenceExpression.getVariantsImpl(refExpr, processor);
        GroovyResolveResult[] candidates = processor.getCandidates();
        List<LookupElement> results = GroovyCompletionUtil.getCompletionVariants(candidates, JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)refExpr), matcher, (PsiElement)refExpr);
        if (count[0] == 0 && results.size() == 0) {
            results = GroovyCompletionUtil.getCompletionVariants(processor.getInapplicableResults(), JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)refExpr), matcher, (PsiElement)refExpr);
        }
        for (LookupElement o : results) {
            consumer.consume((Object)o);
        }
    }

    public static void processRefInAnnotation(@NotNull GrReferenceExpression refExpr, @NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processRefInAnnotation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processRefInAnnotation"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processRefInAnnotation"));
        }
        if (refExpr.getParent() instanceof GrAnnotationNameValuePair && ((GrAnnotationNameValuePair)refExpr.getParent()).getNameIdentifierGroovy() == null) {
            PsiElement parent = refExpr.getParent().getParent();
            if (!(parent instanceof GrAnnotation)) {
                parent = parent.getParent();
            }
            if (parent instanceof GrAnnotation) {
                for (LookupElement result : GroovyCompletionUtil.getAnnotationCompletionResults((GrAnnotation)parent, matcher)) {
                    consumer.consume((Object)result);
                }
            }
        }
    }

    private static void processIfJavaLangClass(@NotNull GrReferenceExpression refExpr, @NotNull ResolverProcessor consumer, @Nullable PsiType type) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processIfJavaLangClass"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "processIfJavaLangClass"));
        }
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null || !"java.lang.Class".equals(psiClass.getQualifiedName())) {
            return;
        }
        PsiType[] params = ((PsiClassType)type).getParameters();
        if (params.length != 1) {
            return;
        }
        CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, consumer, params[0], refExpr.getProject());
    }

    private static void getVariantsImpl(@NotNull GrReferenceExpression refExpr, @NotNull CompleteReferenceProcessor processor) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsImpl"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsImpl"));
        }
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            ResolveUtil.treeWalkUp(refExpr, processor, true);
            for (PsiElement e = refExpr.getParent(); e != null; e = e.getParent()) {
                if (!(e instanceof GrClosableBlock)) continue;
                ResolveState state = ResolveState.initial().put(ResolverProcessor.RESOLVE_CONTEXT, (Object)e);
                for (ClosureMissingMethodContributor contributor : (ClosureMissingMethodContributor[])ClosureMissingMethodContributor.EP_NAME.getExtensions()) {
                    contributor.processMembers((GrClosableBlock)e, processor, refExpr, state);
                }
            }
            GrExpression runtimeQualifier = PsiImplUtil.getRuntimeQualifier(refExpr);
            if (runtimeQualifier != null) {
                CompleteReferenceExpression.getVariantsFromQualifier(refExpr, processor, runtimeQualifier);
            }
            CompleteReferenceExpression.getBindings(refExpr, processor);
        } else if (refExpr.getDotTokenType() != GroovyTokenTypes.mSPREAD_DOT) {
            CompleteReferenceExpression.getVariantsFromQualifier(refExpr, processor, qualifier);
            if (qualifier instanceof GrReferenceExpression && ("class".equals(((GrReferenceExpression)qualifier).getReferenceName()) || PsiUtil.isThisReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier))) {
                CompleteReferenceExpression.processIfJavaLangClass(refExpr, processor, qualifier.getType());
            }
        } else {
            CompleteReferenceExpression.getVariantsFromQualifierForSpreadOperator(refExpr, processor, qualifier);
        }
        ResolveUtil.processCategoryMembers(refExpr, processor, ResolveState.initial());
    }

    private static void getBindings(@NotNull GrReferenceExpression refExpr, final @NotNull CompleteReferenceProcessor processor) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getBindings"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getBindings"));
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class);
        if (containingClass != null) {
            return;
        }
        final PsiFile file = FileContextUtil.getContextFile((PsiElement)refExpr);
        if (file instanceof GroovyFile) {
            ((GroovyFile)file).accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitAssignmentExpression(GrAssignmentExpression expression) {
                    super.visitAssignmentExpression(expression);
                    GrExpression value = expression.getLValue();
                    if (value instanceof GrReferenceExpression && !((GrReferenceExpression)value).isQualified()) {
                        PsiElement resolved = ((GrReferenceExpression)value).resolve();
                        if (resolved instanceof GrBindingVariable) {
                            processor.execute(resolved, ResolveState.initial());
                        } else if (resolved == null) {
                            processor.execute(new GrBindingVariable((GroovyFile)file, ((GrReferenceExpression)value).getReferenceName(), true), ResolveState.initial());
                        }
                    }
                }

                @Override
                public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
                }
            });
        }
    }

    private static void getVariantsFromQualifierForSpreadOperator(@NotNull GrReferenceExpression refExpr, @NotNull ResolverProcessor processor, @NotNull GrExpression qualifier) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifierForSpreadOperator"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifierForSpreadOperator"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifierForSpreadOperator"));
        }
        PsiType spreadType = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)refExpr);
        if (spreadType != null) {
            CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, spreadType, refExpr.getProject());
        }
    }

    @NotNull
    public static LookupElementBuilder createPropertyLookupElement(@NotNull String name, @Nullable PsiType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "createPropertyLookupElement"));
        }
        LookupElementBuilder res = LookupElementBuilder.create((String)name).withIcon(JetgroovyIcons.Groovy.Property);
        if (type != null) {
            res = res.withTypeText(type.getPresentableText());
        }
        LookupElementBuilder lookupElementBuilder = res;
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "createPropertyLookupElement"));
        }
        return lookupElementBuilder;
    }

    @Nullable
    public static LookupElementBuilder createPropertyLookupElement(@NotNull PsiMethod accessor, @Nullable GroovyResolveResult resolveResult, @Nullable PrefixMatcher matcher) {
        String propName;
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "createPropertyLookupElement"));
        }
        boolean getter = GroovyPropertyUtils.isSimplePropertyGetter(accessor, null);
        if (getter) {
            propName = GroovyPropertyUtils.getPropertyNameByGetter(accessor);
        } else if (GroovyPropertyUtils.isSimplePropertySetter(accessor, null)) {
            propName = GroovyPropertyUtils.getPropertyNameBySetter(accessor);
        } else {
            return null;
        }
        assert (propName != null);
        if (!PsiUtil.isValidReferenceName(propName)) {
            propName = "'" + propName + "'";
        }
        if (matcher != null && !matcher.prefixMatches(propName)) {
            return null;
        }
        PsiType propType = getter ? PsiUtil.getSmartReturnType(accessor) : accessor.getParameterList().getParameters()[0].getType();
        PsiType substituted = resolveResult != null ? resolveResult.getSubstitutor().substitute(propType) : propType;
        LookupElementBuilder builder = LookupElementBuilder.create((Object)CompleteReferenceExpression.generatePropertyResolveResult(propName, accessor, propType, resolveResult), (String)propName).withIcon(JetgroovyIcons.Groovy.Property);
        if (substituted != null) {
            builder = builder.withTypeText(substituted.getPresentableText());
        }
        return builder;
    }

    @NotNull
    private static GroovyResolveResult generatePropertyResolveResult(@NotNull String name, @NotNull PsiMethod method, @Nullable PsiType type, @Nullable GroovyResolveResult resolveResult) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "generatePropertyResolveResult"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "generatePropertyResolveResult"));
        }
        PsiType nonNullType = type != null ? type : TypesUtil.getJavaLangObject((PsiElement)method);
        GrPropertyForCompletion field = new GrPropertyForCompletion(method, name, nonNullType);
        if (resolveResult != null) {
            GroovyResolveResultImpl groovyResolveResultImpl = new GroovyResolveResultImpl((PsiElement)field, resolveResult.getCurrentFileResolveContext(), resolveResult.getSpreadState(), resolveResult.getSubstitutor(), resolveResult.isAccessible(), resolveResult.isStaticsOK());
            if (groovyResolveResultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "generatePropertyResolveResult"));
            }
            return groovyResolveResultImpl;
        }
        GroovyResolveResultImpl groovyResolveResultImpl = new GroovyResolveResultImpl((PsiElement)field, true);
        if (groovyResolveResultImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "generatePropertyResolveResult"));
        }
        return groovyResolveResultImpl;
    }

    private static void getVariantsFromQualifier(@NotNull GrReferenceExpression refExpr, @NotNull ResolverProcessor processor, @NotNull GrExpression qualifier) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifier"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifier"));
        }
        Project project = qualifier.getProject();
        PsiType qualifierType = qualifier.getType();
        ResolveState state = ResolveState.initial();
        if (qualifierType == null || qualifierType == PsiType.VOID) {
            PsiElement resolved;
            if (qualifier instanceof GrReferenceExpression && ((resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiPackage || resolved instanceof PsiVariable)) {
                resolved.processDeclarations((PsiScopeProcessor)processor, state, null, (PsiElement)refExpr);
                return;
            }
            CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, (PsiType)PsiType.getJavaLangObject((PsiManager)refExpr.getManager(), (GlobalSearchScope)qualifier.getResolveScope()), project);
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, conjunct, project);
            }
        } else {
            GlobalSearchScope scope;
            PsiClass javaLangClass;
            PsiElement resolved;
            CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, qualifierType, project);
            if (qualifier instanceof GrReferenceExpression && !PsiUtil.isSuperReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass && (javaLangClass = PsiUtil.getJavaLangClass(resolved, scope = refExpr.getResolveScope())) != null) {
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
                if (typeParameters.length == 1) {
                    substitutor = substitutor.put(typeParameters[0], qualifierType);
                }
                PsiClassType javaLangClassType = JavaPsiFacade.getElementFactory((Project)refExpr.getProject()).createType(javaLangClass, substitutor);
                ResolveUtil.processAllDeclarations((PsiType)javaLangClassType, processor, state, refExpr);
            }
        }
    }

    @NotNull
    public static Set<String> getVariantsWithSameQualifier(@NotNull PrefixMatcher matcher, @Nullable GrExpression qualifier, @NotNull GrReferenceExpression refExpr) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsWithSameQualifier"));
        }
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsWithSameQualifier"));
        }
        if (qualifier != null && qualifier.getType() != null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsWithSameQualifier"));
            }
            return set;
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)refExpr, (Class[])new Class[]{GrMember.class, PsiFile.class});
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (scope != null) {
            CompleteReferenceExpression.addVariantsWithSameQualifier(matcher, scope, refExpr, qualifier, result);
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsWithSameQualifier"));
        }
        return linkedHashSet;
    }

    private static void addVariantsWithSameQualifier(@NotNull PrefixMatcher matcher, @NotNull PsiElement element, @NotNull GrReferenceExpression patternExpression, @Nullable GrExpression patternQualifier, @NotNull Set<String> result) {
        GrReferenceExpression refExpr;
        String refName;
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "addVariantsWithSameQualifier"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "addVariantsWithSameQualifier"));
        }
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "addVariantsWithSameQualifier"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "addVariantsWithSameQualifier"));
        }
        if (element instanceof GrReferenceExpression && element != patternExpression && !PsiUtil.isLValue((GroovyPsiElement)element) && (refName = (refExpr = (GrReferenceExpression)element).getReferenceName()) != null && !result.contains(refName) && matcher.prefixMatches(refName)) {
            GrExpression hisQualifier = refExpr.getQualifierExpression();
            if (hisQualifier != null && patternQualifier != null) {
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)hisQualifier, (PsiElement)patternQualifier) && refExpr.resolve() == null) {
                    result.add(refName);
                }
            } else if (hisQualifier == null && patternQualifier == null && refExpr.resolve() == null) {
                result.add(refName);
            }
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            CompleteReferenceExpression.addVariantsWithSameQualifier(matcher, child, patternExpression, patternQualifier, result);
        }
    }

    private static void getVariantsFromQualifierType(@NotNull GrReferenceExpression refExpr, @NotNull ResolverProcessor processor, @NotNull PsiType qualifierType, @NotNull Project project) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifierType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifierType"));
        }
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifierType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "getVariantsFromQualifierType"));
        }
        ResolveState state = ResolveState.initial();
        if (qualifierType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)qualifierType).resolveGenerics();
            PsiClass qualifierClass = result.getElement();
            if (qualifierClass != null) {
                qualifierClass.processDeclarations((PsiScopeProcessor)processor, state.put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()), null, (PsiElement)refExpr);
            }
        } else if (qualifierType instanceof PsiArrayType) {
            GrTypeDefinition arrayClass = GroovyPsiManager.getInstance(project).getArrayClass(((PsiArrayType)qualifierType).getComponentType());
            if (arrayClass != null && !arrayClass.processDeclarations(processor, state, null, refExpr)) {
                return;
            }
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, conjunct, project);
            }
            return;
        }
        ResolveUtil.processNonCodeMembers(qualifierType, processor, refExpr, state);
    }

    @NotNull
    private static Set<String> addAllRestrictedProperties(@NotNull GrReferenceExpression place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "addAllRestrictedProperties"));
        }
        if (place.getQualifier() != null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "addAllRestrictedProperties"));
            }
            return set;
        }
        com.intellij.util.containers.hash.HashSet propertyNames = new com.intellij.util.containers.hash.HashSet();
        GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, GrTypeDefinition.class);
        while (containingClass != null) {
            for (GrField field : containingClass.getFields()) {
                propertyNames.add(field.getName());
            }
            containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)containingClass, GrTypeDefinition.class);
        }
        com.intellij.util.containers.hash.HashSet hashSet = propertyNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "addAllRestrictedProperties"));
        }
        return hashSet;
    }

    private static boolean isMap(@NotNull GrReferenceExpression place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression", "isMap"));
        }
        PsiType qType = GrReferenceResolveUtil.getQualifierType(place);
        return InheritanceUtil.isInheritor((PsiType)qType, (String)"java.util.Map");
    }

    private static class CompleteReferenceProcessor
    extends ResolverProcessor
    implements Consumer<Object> {
        private static final Logger LOG = Logger.getInstance(CompleteReferenceProcessor.class);
        private final Consumer<LookupElement> myConsumer;
        private final PrefixMatcher myMatcher;
        private final CompletionParameters myParameters;
        private final boolean mySkipPackages;
        private final PsiClass myEventListener;
        private final boolean myMethodPointerOperator;
        private final boolean myFieldPointerOperator;
        private final boolean myIsMap;
        private final SubstitutorComputer mySubstitutorComputer;
        private Collection<String> myPreferredFieldNames;
        private final Set<String> myPropertyNames;
        private final Set<String> myLocalVars;
        private final Set<GrMethod> myProcessedMethodWithOptionalParams;
        private List<GroovyResolveResult> myInapplicable;

        protected CompleteReferenceProcessor(@NotNull GrReferenceExpression place, @NotNull Consumer<LookupElement> consumer, @NotNull PrefixMatcher matcher, @NotNull CompletionParameters parameters) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "<init>"));
            }
            if (matcher == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "<init>"));
            }
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "<init>"));
            }
            super(null, EnumSet.allOf(ClassHint.ResolveKind.class), place, PsiType.EMPTY_ARRAY);
            this.myPropertyNames = new com.intellij.util.containers.hash.HashSet();
            this.myLocalVars = new com.intellij.util.containers.hash.HashSet();
            this.myProcessedMethodWithOptionalParams = new com.intellij.util.containers.hash.HashSet();
            this.myConsumer = consumer;
            this.myMatcher = matcher;
            this.myParameters = parameters;
            this.myPreferredFieldNames = CompleteReferenceExpression.addAllRestrictedProperties(place);
            this.mySkipPackages = CompleteReferenceProcessor.shouldSkipPackages(place);
            this.myEventListener = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("java.util.EventListener", place.getResolveScope());
            this.myPropertyNames.addAll(this.myPreferredFieldNames);
            this.myFieldPointerOperator = place.hasAt();
            this.myMethodPointerOperator = place.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER;
            this.myIsMap = CompleteReferenceExpression.isMap(place);
            PsiType thisType = GrReferenceResolveUtil.getQualifierType(place);
            this.mySubstitutorComputer = new SubstitutorComputer(thisType, PsiType.EMPTY_ARRAY, PsiType.EMPTY_ARRAY, place, place.getParent());
        }

        private static boolean shouldSkipPackages(@NotNull GrReferenceExpression place) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "shouldSkipPackages"));
            }
            if (PsiImplUtil.getRuntimeQualifier(place) != null) {
                return false;
            }
            PsiElement parent = place.getParent();
            return parent == null || parent.getLanguage().isKindOf(GroovyFileType.GROOVY_LANGUAGE);
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "execute"));
            }
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                return true;
            }
            if (element instanceof PsiNamedElement) {
                PsiNamedElement namedElement = (PsiNamedElement)element;
                boolean isAccessible = this.isAccessible(namedElement);
                PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
                SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
                boolean isStaticsOK = this.isStaticsOK(namedElement, resolveContext, this.myParameters.getInvocationCount() <= 1);
                PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
                if (substitutor == null) {
                    substitutor = PsiSubstitutor.EMPTY;
                }
                if (element instanceof PsiMethod) {
                    substitutor = this.mySubstitutorComputer.obtainSubstitutor(substitutor, (PsiMethod)element, state);
                }
                this.consume(new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK));
            }
            return true;
        }

        public void consume(Object o) {
            if (!(o instanceof GroovyResolveResult)) {
                LOG.error(o);
                return;
            }
            GroovyResolveResult result = (GroovyResolveResult)o;
            if (!result.isStaticsOK()) {
                if (this.myInapplicable == null) {
                    this.myInapplicable = ContainerUtil.newArrayList();
                }
                this.myInapplicable.add(result);
                return;
            }
            if (!result.isAccessible() && this.myParameters.getInvocationCount() < 2) {
                return;
            }
            if (this.mySkipPackages && result.getElement() instanceof PsiPackage) {
                return;
            }
            PsiElement element = result.getElement();
            if (element instanceof PsiVariable && !this.myMatcher.prefixMatches(((PsiVariable)element).getName())) {
                return;
            }
            if (element instanceof GrReflectedMethod) {
                if (!this.myProcessedMethodWithOptionalParams.add((GrMethod)(element = ((GrReflectedMethod)element).getBaseMethod()))) {
                    return;
                }
                result = new GroovyResolveResultImpl(element, result.getCurrentFileResolveContext(), result.getSpreadState(), result.getSubstitutor(), result.isAccessible(), result.isStaticsOK(), result.isInvokedOnProperty(), result.isValidResult());
            }
            if (this.myFieldPointerOperator && !(element instanceof PsiVariable)) {
                return;
            }
            if (this.myMethodPointerOperator && !(element instanceof PsiMethod)) {
                return;
            }
            this.addCandidate(result);
            if (!this.myFieldPointerOperator && !this.myMethodPointerOperator) {
                if (element instanceof PsiMethod) {
                    this.processProperty((PsiMethod)element, result);
                } else if (element instanceof GrField && ((GrField)element).isProperty()) {
                    this.processPropertyFromField((GrField)element, result);
                }
            }
            if (element instanceof GrVariable && !(element instanceof GrField)) {
                this.myLocalVars.add(((GrVariable)element).getName());
            }
        }

        private void processPropertyFromField(@NotNull GrField field, @NotNull GroovyResolveResult resolveResult) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "processPropertyFromField"));
            }
            if (resolveResult == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "processPropertyFromField"));
            }
            if (field.getGetters().length != 0 || field.getSetter() != null || !this.myPropertyNames.add(field.getName()) || this.myIsMap) {
                return;
            }
            for (LookupElement lookupElement : GroovyCompletionUtil.createLookupElements(resolveResult, false, this.myMatcher, null)) {
                this.myConsumer.consume((Object)((LookupElementBuilder)lookupElement).withIcon(JetgroovyIcons.Groovy.Property));
            }
        }

        private void processProperty(@NotNull PsiMethod method, @NotNull GroovyResolveResult resolveResult) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "processProperty"));
            }
            if (resolveResult == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "processProperty"));
            }
            if (this.myIsMap) {
                return;
            }
            LookupElementBuilder lookup = CompleteReferenceExpression.createPropertyLookupElement(method, resolveResult, this.myMatcher);
            if (lookup != null) {
                if (this.myPropertyNames.add(lookup.getLookupString())) {
                    this.myConsumer.consume((Object)lookup);
                }
            } else if (this.myEventListener != null) {
                this.processListenerProperties(method);
            }
        }

        private void processListenerProperties(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "processListenerProperties"));
            }
            if (!method.getName().startsWith("add") || method.getParameterList().getParametersCount() != 1) {
                return;
            }
            PsiParameter parameter = method.getParameterList().getParameters()[0];
            PsiType type = parameter.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass listenerClass = classType.resolve();
            if (listenerClass == null) {
                return;
            }
            PsiMethod[] listenerMethods = listenerClass.getMethods();
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)listenerClass, (PsiClass)this.myEventListener, (boolean)true)) {
                return;
            }
            for (PsiMethod listenerMethod : listenerMethods) {
                String name = listenerMethod.getName();
                if (!this.myPropertyNames.add(name)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)CompleteReferenceExpression.generatePropertyResolveResult(name, listenerMethod, null, null), (String)name).withIcon(JetgroovyIcons.Groovy.Property);
                this.myConsumer.consume((Object)builder);
            }
        }

        @Override
        @NotNull
        public GroovyResolveResult[] getCandidates() {
            if (!this.hasCandidates()) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "getCandidates"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GroovyResolveResult[] results = ResolveUtil.filterSameSignatureCandidates(this.getCandidatesInternal());
            ArrayList<GroovyResolveResult> list = new ArrayList<GroovyResolveResult>(results.length);
            this.myPropertyNames.removeAll(this.myPreferredFieldNames);
            HashSet usedFields = ContainerUtil.newHashSet();
            for (GroovyResolveResult result : results) {
                PsiElement element = result.getElement();
                if (element instanceof PsiField) {
                    String name = ((PsiField)element).getName();
                    if (this.myPropertyNames.contains(name) || this.myLocalVars.contains(name) || usedFields.contains(name)) continue;
                    usedFields.add(name);
                }
                list.add(result);
            }
            GroovyResolveResult[] groovyResolveResultArray = list.toArray(new GroovyResolveResult[list.size()]);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "getCandidates"));
            }
            return groovyResolveResultArray;
        }

        @NotNull
        private List<GroovyResolveResult> getInapplicableResults() {
            if (this.myInapplicable == null) {
                List<GroovyResolveResult> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "getInapplicableResults"));
                }
                return list;
            }
            List<GroovyResolveResult> list = this.myInapplicable;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/CompleteReferenceExpression$CompleteReferenceProcessor", "getInapplicableResults"));
            }
            return list;
        }
    }
}

