/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignatureVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;

class GrClosableSignatureImpl
implements GrClosureSignature {
    private final GrClosableBlock myBlock;

    public GrClosableSignatureImpl(GrClosableBlock block) {
        this.myBlock = block;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosableSignatureImpl", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public GrClosureParameter[] getParameters() {
        Object[] parameters = this.myBlock.getAllParameters();
        GrClosureParameter[] grClosureParameterArray = (GrClosureParameter[])ContainerUtil.map((Object[])parameters, (Function)new Function<GrParameter, GrClosureParameter>(){

            public GrClosureParameter fun(GrParameter parameter) {
                return new GrClosureParameterImpl(parameter);
            }
        }, (Object[])new GrClosureParameter[parameters.length]);
        if (grClosureParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosableSignatureImpl", "getParameters"));
        }
        return grClosureParameterArray;
    }

    @Override
    public int getParameterCount() {
        return this.myBlock.getAllParameters().length;
    }

    @Override
    public boolean isVarargs() {
        GrParameter last = (GrParameter)ArrayUtil.getLastElement((Object[])this.myBlock.getAllParameters());
        return last != null && last.getType() instanceof PsiArrayType;
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.myBlock.getReturnType();
    }

    @Override
    public boolean isCurried() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myBlock.isValid();
    }

    @Override
    @Nullable
    public GrSignature curry(@NotNull PsiType[] args, int position, @NotNull PsiElement context) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosableSignatureImpl", "curry"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosableSignatureImpl", "curry"));
        }
        return GrClosureSignatureUtil.curryImpl(this, args, position, context);
    }

    @Override
    public void accept(GrSignatureVisitor visitor) {
        visitor.visitClosureSignature(this);
    }

    private static class GrClosureParameterImpl
    implements GrClosureParameter {
        private final GrParameter myParameter;

        public GrClosureParameterImpl(GrParameter parameter) {
            this.myParameter = parameter;
        }

        @Override
        @Nullable
        public PsiType getType() {
            return this.myParameter.getType();
        }

        @Override
        public boolean isOptional() {
            return this.myParameter.isOptional();
        }

        @Override
        @Nullable
        public GrExpression getDefaultInitializer() {
            return this.myParameter.getInitializerGroovy();
        }

        @Override
        public boolean isValid() {
            return this.myParameter.isValid();
        }

        @Override
        @Nullable
        public String getName() {
            return this.myParameter.getName();
        }
    }
}

