/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrTupleType
extends GrLiteralClassType {
    private final VolatileNotNullLazyValue<PsiType[]> myParameters;
    private final VolatileNotNullLazyValue<PsiType[]> myComponents;

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "<init>"));
        }
        this(scope, facade, LanguageLevel.JDK_1_5);
    }

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull LanguageLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "<init>"));
        }
        super(level, scope, facade);
        this.myParameters = new VolatileNotNullLazyValue<PsiType[]>(){

            @NotNull
            protected PsiType[] compute() {
                PsiType[] types = GrTupleType.this.getComponentTypes();
                if (types.length == 0) {
                    if (PsiType.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType$1", "compute"));
                    }
                    return PsiType.EMPTY_ARRAY;
                }
                PsiType leastUpperBound = GrTupleType.this.getLeastUpperBound(types);
                if (leastUpperBound == PsiType.NULL) {
                    if (PsiClassType.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType$1", "compute"));
                    }
                    return PsiClassType.EMPTY_ARRAY;
                }
                PsiType[] psiTypeArray = new PsiType[]{leastUpperBound};
                if (psiTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType$1", "compute"));
                }
                return psiTypeArray;
            }
        };
        this.myComponents = new VolatileNotNullLazyValue<PsiType[]>(){

            @NotNull
            protected PsiType[] compute() {
                PsiType[] psiTypeArray = GrTupleType.this.inferComponents();
                if (psiTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType$2", "compute"));
                }
                return psiTypeArray;
            }
        };
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        if ("java.util.ArrayList" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "getJavaClassName"));
        }
        return "java.util.ArrayList";
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = StringUtil.getShortName((String)this.getJavaClassName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "getClassName"));
        }
        return string;
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = (PsiType[])this.myParameters.getValue();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "getParameters"));
        }
        return psiTypeArray;
    }

    @NotNull
    public String getInternalCanonicalText() {
        PsiType[] types = this.getComponentTypes();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < types.length; ++i) {
            if (i >= 2) {
                builder.append(",...");
                break;
            }
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(GrTupleType.getInternalCanonicalText(types[i]));
        }
        builder.append("]");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "getInternalCanonicalText"));
        }
        return string;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrTupleType) {
            PsiType[] componentTypes = this.getComponentTypes();
            PsiType[] otherComponents = ((GrTupleType)((Object)obj)).getComponentTypes();
            for (int i = 0; i < Math.min(componentTypes.length, otherComponents.length); ++i) {
                if (Comparing.equal((Object)componentTypes[i], (Object)otherComponents[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "isAssignableFrom"));
        }
        if (type instanceof GrTupleType) {
            PsiType[] otherComponents = ((GrTupleType)type).getComponentTypes();
            PsiType[] componentTypes = this.getComponentTypes();
            for (int i = 0; i < Math.min(componentTypes.length, otherComponents.length); ++i) {
                PsiType componentType = componentTypes[i];
                PsiType otherComponent = otherComponents[i];
                if (!(otherComponent == null ? componentType != null && !TypesUtil.isClassType(componentType, "java.lang.Object") : componentType != null && !componentType.isAssignableFrom(otherComponent))) continue;
                return false;
            }
            return true;
        }
        return super.isAssignableFrom(type);
    }

    @NotNull
    public PsiType[] getComponentTypes() {
        PsiType[] psiTypeArray = (PsiType[])this.myComponents.getValue();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "getComponentTypes"));
        }
        return psiTypeArray;
    }

    @NotNull
    protected abstract PsiType[] inferComponents();

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "setLanguageLevel"));
        }
        GrImmediateTupleType grImmediateTupleType = new GrImmediateTupleType(this.getComponentTypes(), this.myFacade, this.getResolveScope());
        if (grImmediateTupleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType", "setLanguageLevel"));
        }
        return grImmediateTupleType;
    }
}

