/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GrMapTypeFromNamedArgs
extends GrMapType {
    private final Map<String, GrExpression> myStringEntries;
    private final List<Pair<GrExpression, GrExpression>> myOtherEntries;
    private final VolatileNotNullLazyValue<List<Pair<PsiType, PsiType>>> myTypesOfOtherEntries;
    private final VolatileNotNullLazyValue<Map<String, PsiType>> myTypesOfStringEntries;

    public GrMapTypeFromNamedArgs(@NotNull PsiElement context, @NotNull GrNamedArgument[] namedArgs) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        if (namedArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        this(JavaPsiFacade.getInstance((Project)context.getProject()), context.getResolveScope(), namedArgs);
    }

    public GrMapTypeFromNamedArgs(@NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @NotNull GrNamedArgument[] namedArgs) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        if (namedArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        super(facade, scope);
        this.myTypesOfOtherEntries = new VolatileNotNullLazyValue<List<Pair<PsiType, PsiType>>>(){

            @NotNull
            protected List<Pair<PsiType, PsiType>> compute() {
                List list = ContainerUtil.map((Collection)GrMapTypeFromNamedArgs.this.myOtherEntries, (Function)new Function<Pair<GrExpression, GrExpression>, Pair<PsiType, PsiType>>(){

                    public Pair<PsiType, PsiType> fun(Pair<GrExpression, GrExpression> pair) {
                        return Pair.create((Object)((GrExpression)pair.first).getType(), (Object)((GrExpression)pair.second).getType());
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs$1", "compute"));
                }
                return list;
            }
        };
        this.myTypesOfStringEntries = new VolatileNotNullLazyValue<Map<String, PsiType>>(){

            @NotNull
            protected Map<String, PsiType> compute() {
                HashMap result = ContainerUtil.newHashMap();
                for (Map.Entry entry : GrMapTypeFromNamedArgs.this.myStringEntries.entrySet()) {
                    result.put(entry.getKey(), ((GrExpression)entry.getValue()).getType());
                }
                HashMap hashMap = result;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs$2", "compute"));
                }
                return hashMap;
            }
        };
        this.myStringEntries = ContainerUtil.newHashMap();
        this.myOtherEntries = ContainerUtil.newArrayList();
        for (GrNamedArgument namedArg : namedArgs) {
            GrArgumentLabel label = namedArg.getLabel();
            GrExpression expression = namedArg.getExpression();
            if (label == null || expression == null) continue;
            String name = label.getName();
            if (name != null) {
                this.myStringEntries.put(name, expression);
                continue;
            }
            if (label.getExpression() == null) continue;
            this.myOtherEntries.add((Pair<GrExpression, GrExpression>)Pair.create((Object)label.getExpression(), (Object)expression));
        }
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        GrExpression expression = this.myStringEntries.get(key);
        return expression != null ? expression.getType() : null;
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        Set<String> set = this.myStringEntries.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getStringKeys"));
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    @Override
    @NotNull
    protected PsiType[] getAllKeyTypes() {
        HashSet result = ContainerUtil.newHashSet();
        if (!this.myStringEntries.isEmpty()) {
            result.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Pair<GrExpression, GrExpression> entry : this.myOtherEntries) {
            result.add(((GrExpression)entry.first).getType());
        }
        result.remove(null);
        PsiType[] psiTypeArray = result.toArray(GrMapTypeFromNamedArgs.createArray((int)result.size()));
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getAllKeyTypes"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    protected PsiType[] getAllValueTypes() {
        HashSet result = ContainerUtil.newHashSet();
        for (GrExpression grExpression : this.myStringEntries.values()) {
            result.add(grExpression.getType());
        }
        for (Pair pair : this.myOtherEntries) {
            result.add(((GrExpression)pair.second).getType());
        }
        result.remove(null);
        PsiType[] psiTypeArray = result.toArray(GrMapTypeFromNamedArgs.createArray((int)result.size()));
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getAllValueTypes"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    protected List<Pair<PsiType, PsiType>> getOtherEntries() {
        List list = (List)this.myTypesOfOtherEntries.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getOtherEntries"));
        }
        return list;
    }

    @Override
    @NotNull
    protected Map<String, PsiType> getStringEntries() {
        Map map = (Map)this.myTypesOfStringEntries.getValue();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getStringEntries"));
        }
        return map;
    }

    public boolean isValid() {
        for (GrExpression grExpression : this.myStringEntries.values()) {
            if (grExpression.isValid()) continue;
            return false;
        }
        for (Pair pair : this.myOtherEntries) {
            if (!((GrExpression)pair.first).isValid()) {
                return false;
            }
            if (((GrExpression)pair.second).isValid()) continue;
            return false;
        }
        return true;
    }
}

