/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GrAnnotationUtil {
    @Nullable
    public static String inferStringAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        Object value;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferStringAttribute"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferStringAttribute"));
        }
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    public static Integer inferIntegerAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        Object value;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferIntegerAttribute"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferIntegerAttribute"));
        }
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    @Nullable
    public static Boolean inferBooleanAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        Object value;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferBooleanAttribute"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferBooleanAttribute"));
        }
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    @Nullable
    public static PsiClass inferClassAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferClassAttribute"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil", "inferClassAttribute"));
        }
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            PsiType type = ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
            if (type instanceof PsiClassType) {
                return ((PsiClassType)type).resolve();
            }
        } else if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return (PsiClass)resolved;
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return (PsiClass)resolved2;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType extractClassTypeFromClassAttributeValue(PsiAnnotationMemberValue targetValue) {
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            return ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
        }
        if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return qualifier.getType();
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return ((GrReferenceExpression)targetValue).getType();
            }
        }
        return null;
    }
}

